/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.timeout;

import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.WrappedMessageHandlingMember;
import org.axonframework.messaging.timeout.AxonTimeLimitedTask;

class TimeoutWrappedMessageHandlingMember<T>
extends WrappedMessageHandlingMember<T> {
    private final int timeout;
    private final int warningThreshold;
    private final int warningInterval;

    TimeoutWrappedMessageHandlingMember(MessageHandlingMember<T> original, int timeout, int warningThreshold, int warningInterval) {
        super(original);
        this.timeout = timeout;
        this.warningThreshold = warningThreshold;
        this.warningInterval = warningInterval;
    }

    @Override
    public Object handleSync(@Nonnull Message<?> message, T target) throws Exception {
        String taskName = String.format("Message [%s] for handler [%s]", message.getPayloadType().getName(), target != null ? target.getClass().getName() : null);
        AxonTimeLimitedTask taskTimeout = new AxonTimeLimitedTask(taskName, this.timeout, this.warningThreshold, this.warningInterval);
        taskTimeout.start();
        try {
            Object object = super.handleSync(message, target);
            return object;
        }
        catch (InterruptedException e) {
            throw new TimeoutException(String.format("%s has timed out", taskName));
        }
        finally {
            taskTimeout.complete();
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getWarningThreshold() {
        return this.warningThreshold;
    }

    public int getWarningInterval() {
        return this.warningInterval;
    }
}

