/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.interceptors;

import javax.annotation.Nonnull;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.LegacyUnitOfWork;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class TransactionManagingInterceptor<T extends Message<?>>
implements MessageHandlerInterceptor<T> {
    private final TransactionManager transactionManager;

    public TransactionManagingInterceptor(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public Object handle(@Nonnull LegacyUnitOfWork<? extends T> unitOfWork, @Nonnull InterceptorChain interceptorChain) throws Exception {
        Transaction transaction = this.transactionManager.startTransaction();
        unitOfWork.onCommit(u -> transaction.commit());
        unitOfWork.onRollback(u -> transaction.rollback());
        return interceptorChain.proceedSync();
    }

    @Override
    public <M extends T, R extends Message<?>> MessageStream<? extends R> interceptOnHandle(@Nonnull M message, @Nonnull ProcessingContext context, @Nonnull InterceptorChain<M, R> interceptorChain) {
        Transaction transaction = this.transactionManager.startTransaction();
        context.runOnCommit(u -> transaction.commit());
        context.onError((u, p, e) -> transaction.rollback());
        return interceptorChain.proceed(message, context);
    }
}

