/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.interceptors;

import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.LegacyUnitOfWork;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInterceptor<T extends Message<?>>
implements MessageDispatchInterceptor<T>,
MessageHandlerInterceptor<T> {
    private final Logger logger;

    public LoggingInterceptor(String loggerName) {
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }

    public LoggingInterceptor() {
        this.logger = LoggerFactory.getLogger(LoggingInterceptor.class);
    }

    @Override
    public <M extends T, R extends Message<?>> MessageStream<? extends R> interceptOnDispatch(@Nonnull M message, @Nullable ProcessingContext context, @Nonnull InterceptorChain<M, R> interceptorChain) {
        this.logger.info("Dispatched message: [{}]", (Object)message.getPayloadType().getSimpleName());
        return interceptorChain.proceed(message, context);
    }

    @Override
    public <M extends T, R extends Message<?>> MessageStream<? extends R> interceptOnHandle(@Nonnull M message, @Nonnull ProcessingContext context, @Nonnull InterceptorChain<M, R> interceptorChain) {
        this.logger.info("Incoming message: [{}]", (Object)message.getPayloadType().getSimpleName());
        return interceptorChain.proceed(message, context).map(returnValue -> {
            this.logger.info("[{}] executed successfully with a [{}] return value", (Object)message.getPayloadType().getSimpleName(), (Object)(returnValue == null ? "null" : returnValue.getClass().getSimpleName()));
            return returnValue;
        }).onErrorContinue(e -> {
            this.logger.info("[{}] resulted in an error", (Object)message.getPayloadType().getSimpleName(), e);
            return MessageStream.failed(e);
        });
    }

    @Override
    @Deprecated
    @Nonnull
    public BiFunction<Integer, T, T> handle(@Nonnull List<? extends T> messages) {
        return (i, message) -> {
            this.logger.info("Dispatched messages: [{}]", (Object)message.getPayloadType().getSimpleName());
            return message;
        };
    }

    @Override
    @Deprecated
    public Object handle(@Nonnull LegacyUnitOfWork<? extends T> unitOfWork, @Nonnull InterceptorChain interceptorChain) throws Exception {
        T message = unitOfWork.getMessage();
        this.logger.info("Incoming message: [{}]", (Object)message.getPayloadType().getSimpleName());
        try {
            Object returnValue = interceptorChain.proceedSync();
            this.logger.info("[{}] executed successfully with a [{}] return value", (Object)message.getPayloadType().getSimpleName(), (Object)(returnValue == null ? "null" : returnValue.getClass().getSimpleName()));
            return returnValue;
        }
        catch (Exception t) {
            this.logger.warn("[{}] execution failed:", (Object)message.getPayloadType().getSimpleName(), (Object)t);
            throw t;
        }
    }
}

