/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.interceptors;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.interceptors.JSR303ViolationException;
import org.axonframework.messaging.unitofwork.LegacyUnitOfWork;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class BeanValidationInterceptor<T extends Message<?>>
implements MessageHandlerInterceptor<T>,
MessageDispatchInterceptor<T> {
    private final ValidatorFactory validatorFactory;

    public BeanValidationInterceptor() {
        this(Validation.buildDefaultValidatorFactory());
    }

    public BeanValidationInterceptor(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    @Override
    public <M extends T, R extends Message<?>> MessageStream<? extends R> interceptOnDispatch(@Nonnull M message, @Nullable ProcessingContext context, @Nonnull InterceptorChain<M, R> interceptorChain) {
        return this.intercept(message, context, interceptorChain);
    }

    @Override
    public <M extends T, R extends Message<?>> MessageStream<? extends R> interceptOnHandle(@Nonnull M message, @Nonnull ProcessingContext context, @Nonnull InterceptorChain<M, R> interceptorChain) {
        return this.intercept(message, context, interceptorChain);
    }

    private <M extends T, R extends Message<?>> MessageStream<? extends R> intercept(M message, @Nullable ProcessingContext context, InterceptorChain<M, R> interceptorChain) {
        Set<ConstraintViolation<Object>> violations = this.validate((Message<?>)message);
        if (!violations.isEmpty()) {
            return MessageStream.fromFuture(CompletableFuture.failedFuture(new JSR303ViolationException(violations)));
        }
        return interceptorChain.proceed(message, context);
    }

    private Set<ConstraintViolation<Object>> validate(Message<?> message) {
        Validator validator = this.validatorFactory.getValidator();
        return this.validateMessage(message.getPayload(), validator);
    }

    @Override
    @Deprecated
    public Object handle(@Nonnull LegacyUnitOfWork<? extends T> unitOfWork, @Nonnull InterceptorChain interceptorChain) throws Exception {
        this.handle(unitOfWork.getMessage());
        return interceptorChain.proceedSync();
    }

    @Override
    @Deprecated
    @Nonnull
    public BiFunction<Integer, T, T> handle(@Nonnull List<? extends T> messages) {
        return (index, message) -> {
            Validator validator = this.validatorFactory.getValidator();
            Set<ConstraintViolation<Object>> violations = this.validateMessage(message.getPayload(), validator);
            if (violations != null && !violations.isEmpty()) {
                throw new JSR303ViolationException(violations);
            }
            return message;
        };
    }

    protected Set<ConstraintViolation<Object>> validateMessage(Object message, Validator validator) {
        return validator.validate(message, new Class[0]);
    }
}

