/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.configuration.reflection;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Function;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.Configuration;
import org.axonframework.messaging.annotation.MultiParameterResolverFactory;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

public class ParameterResolverFactoryUtils {
    public static void registerToComponentRegistry(@Nonnull ComponentRegistry componentRegistry, @Nonnull Function<Configuration, ParameterResolverFactory> factory) {
        Objects.requireNonNull(componentRegistry, "ComponentRegistry cannot be null");
        ParameterResolverFactoryUtils.registerToComponentRegistry(componentRegistry, 0, factory);
    }

    public static void registerToComponentRegistry(@Nonnull ComponentRegistry componentRegistry, int order, @Nonnull Function<Configuration, ParameterResolverFactory> factory) {
        Objects.requireNonNull(componentRegistry, "ComponentRegistry cannot be null");
        Objects.requireNonNull(factory, "Factory cannot be null");
        if (!componentRegistry.hasComponent(ParameterResolverFactory.class)) {
            componentRegistry.registerComponent(ParameterResolverFactory.class, factory::apply);
            return;
        }
        componentRegistry.registerDecorator(ParameterResolverFactory.class, order, (config, componentName, component) -> MultiParameterResolverFactory.ordered(component, (ParameterResolverFactory)factory.apply(config)));
    }

    private ParameterResolverFactoryUtils() {
    }
}

