/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.configuration.reflection;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Objects;
import org.axonframework.common.Priority;
import org.axonframework.configuration.Configuration;
import org.axonframework.messaging.annotation.FixedValueParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

@Priority(value=-1073741824)
public class ConfigurationParameterResolverFactory
implements ParameterResolverFactory {
    private final Configuration configuration;

    public ConfigurationParameterResolverFactory(@Nonnull Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration, "The configuration cannot be null.");
    }

    @Override
    public ParameterResolver<?> createInstance(Executable executable, Parameter[] parameters, int parameterIndex) {
        Class<?> componentType = parameters[parameterIndex].getType();
        return this.configuration.getOptionalComponent(componentType).map(FixedValueParameterResolver::new).orElse(null);
    }
}

