/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.configuration;

import jakarta.annotation.Nonnull;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.configuration.MessageHandler;
import org.axonframework.messaging.configuration.MessageHandlingComponent;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.queryhandling.QueryHandler;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericMessageHandlingComponent
implements MessageHandlingComponent {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<QualifiedName, CommandHandler> commandHandlersByName = new ConcurrentHashMap<QualifiedName, CommandHandler>();
    private final Map<QualifiedName, EventHandler> eventHandlersByName = new ConcurrentHashMap<QualifiedName, EventHandler>();
    private final Map<QualifiedName, QueryHandler> queryHandlersByName = new ConcurrentHashMap<QualifiedName, QueryHandler>();

    @Override
    public GenericMessageHandlingComponent subscribe(@Nonnull QualifiedName name, @Nonnull CommandHandler commandHandler) {
        return this.subscribe(name, commandHandler, this.commandHandlersByName);
    }

    @Override
    public GenericMessageHandlingComponent subscribe(@Nonnull QualifiedName name, @Nonnull EventHandler eventHandler) {
        return this.subscribe(name, eventHandler, this.eventHandlersByName);
    }

    @Override
    public GenericMessageHandlingComponent subscribe(@Nonnull QualifiedName name, @Nonnull QueryHandler queryHandler) {
        return this.subscribe(name, queryHandler, this.queryHandlersByName);
    }

    private <H extends MessageHandler> GenericMessageHandlingComponent subscribe(QualifiedName name, H handler, Map<QualifiedName, H> registry) {
        if (handler != this) {
            MessageHandler oldHandler = (MessageHandler)registry.put(name, handler);
            if (oldHandler != null) {
                logger.warn("Duplicate message handler for message name [{}]. Replaced [{}] for [{}].", new Object[]{name, oldHandler, handler});
            }
        } else {
            logger.warn("Ignoring registration of [{}], as it is not recommend to subscribe a MessageHandlingComponent with itself.", handler);
        }
        return this;
    }

    @Override
    public Set<QualifiedName> supportedCommands() {
        return Set.copyOf(this.commandHandlersByName.keySet());
    }

    @Override
    public Set<QualifiedName> supportedEvents() {
        return Set.copyOf(this.eventHandlersByName.keySet());
    }

    @Override
    public Set<QualifiedName> supportedQueries() {
        return Set.copyOf(this.queryHandlersByName.keySet());
    }

    @Override
    @Nonnull
    public MessageStream.Single<? extends CommandResultMessage<?>> handle(@Nonnull CommandMessage<?> command, @Nonnull ProcessingContext context) {
        QualifiedName messageType = command.type().qualifiedName();
        CommandHandler handler = this.commandHandlersByName.get(messageType);
        if (handler == null) {
            return MessageStream.failed(new IllegalArgumentException("No handler found for message type [" + String.valueOf(messageType) + "]"));
        }
        return handler.handle(command, context);
    }

    @Override
    @Nonnull
    public MessageStream.Empty<Message<Void>> handle(@Nonnull EventMessage<?> event, @Nonnull ProcessingContext context) {
        QualifiedName messageType = event.type().qualifiedName();
        EventHandler handler = this.eventHandlersByName.get(messageType);
        if (handler == null) {
            return MessageStream.failed(new IllegalArgumentException("No handler found for message type [" + String.valueOf(messageType) + "]"));
        }
        return handler.handle(event, context);
    }

    @Override
    @Nonnull
    public MessageStream<QueryResponseMessage<?>> handle(@Nonnull QueryMessage<?, ?> query, @Nonnull ProcessingContext context) {
        QualifiedName messageType = query.type().qualifiedName();
        QueryHandler handler = this.queryHandlersByName.get(messageType);
        if (handler == null) {
            return MessageStream.failed(new IllegalArgumentException("No handler found for message type [" + String.valueOf(messageType) + "]"));
        }
        return handler.handle(query, context);
    }
}

