/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.interceptors.ResultHandler;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.messaging.unitofwork.ResourceOverridingProcessingContext;

public class ResultParameterResolverFactory
implements ParameterResolverFactory {
    private static final ThreadLocal<Object> REGISTERED_RESULT = new ThreadLocal();
    private static final Object IGNORE_RESULT_PARAMETER_MARKER = new Object();
    public static final Context.ResourceKey<Object> RESOURCE_KEY = Context.ResourceKey.withLabel("Invocation result for interceptors");

    public static <R> R callWithResult(Object result, ProcessingContext processingContext, Function<ProcessingContext, R> action) {
        ResourceOverridingProcessingContext<Object> wrapped = new ResourceOverridingProcessingContext<Object>(processingContext, RESOURCE_KEY, result);
        return action.apply(wrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callWithResult(Object result, Callable<?> action) throws Exception {
        Object previous = REGISTERED_RESULT.get();
        REGISTERED_RESULT.set(result);
        try {
            Object obj = action.call();
            return obj;
        }
        finally {
            if (previous == null) {
                REGISTERED_RESULT.remove();
            } else {
                REGISTERED_RESULT.set(previous);
            }
        }
    }

    public static <T> T ignoringResultParameters(ProcessingContext processingContext, Function<ProcessingContext, T> action) {
        ResourceOverridingProcessingContext<Object> wrapped = new ResourceOverridingProcessingContext<Object>(processingContext, RESOURCE_KEY, IGNORE_RESULT_PARAMETER_MARKER);
        return action.apply(wrapped);
    }

    @Override
    public ParameterResolver<Object> createInstance(Executable executable, Parameter[] parameters, int parameterIndex) {
        if (Exception.class.isAssignableFrom(parameters[parameterIndex].getType()) && AnnotationUtils.isAnnotationPresent((AnnotatedElement)executable, ResultHandler.class)) {
            return new ExceptionResultParameterResolver(parameters[parameterIndex].getType());
        }
        return null;
    }

    private static class ExceptionResultParameterResolver
    implements ParameterResolver<Object> {
        private final Class<?> parameterType;

        private ExceptionResultParameterResolver(Class<?> resultType) {
            this.parameterType = resultType;
        }

        @Override
        public Object resolveParameterValue(Message<?> message, ProcessingContext processingContext) {
            return REGISTERED_RESULT.get();
        }

        @Override
        public boolean matches(Message<?> message, ProcessingContext processingContext) {
            Object registeredResult = REGISTERED_RESULT.get();
            return IGNORE_RESULT_PARAMETER_MARKER.equals(registeredResult) || this.parameterType.isInstance(registeredResult);
        }
    }
}

