/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.axonframework.common.annotation.PriorityAnnotationComparator;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.annotation.ClasspathHandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.MultiHandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

public class MultiHandlerDefinition
implements HandlerDefinition {
    private final List<HandlerDefinition> handlerDefinitions;
    private final HandlerEnhancerDefinition handlerEnhancerDefinition;

    public static MultiHandlerDefinition ordered(HandlerDefinition ... delegates) {
        return MultiHandlerDefinition.ordered(Arrays.asList(delegates));
    }

    public static MultiHandlerDefinition ordered(HandlerEnhancerDefinition handlerEnhancerDefinition, HandlerDefinition ... delegates) {
        return MultiHandlerDefinition.ordered(Arrays.asList(delegates), handlerEnhancerDefinition);
    }

    public static MultiHandlerDefinition ordered(List<HandlerDefinition> delegates) {
        return new MultiHandlerDefinition(delegates);
    }

    public static MultiHandlerDefinition ordered(List<HandlerDefinition> delegates, HandlerEnhancerDefinition handlerEnhancerDefinition) {
        return new MultiHandlerDefinition(delegates, MultiHandlerEnhancerDefinition.ordered(handlerEnhancerDefinition));
    }

    public MultiHandlerDefinition(HandlerDefinition ... delegates) {
        this(Arrays.asList(delegates));
    }

    public MultiHandlerDefinition(List<HandlerDefinition> delegates) {
        this(delegates, ClasspathHandlerEnhancerDefinition.forClassLoader(Thread.currentThread().getContextClassLoader()));
    }

    public MultiHandlerDefinition(List<HandlerDefinition> delegates, HandlerEnhancerDefinition handlerEnhancerDefinition) {
        this.handlerDefinitions = MultiHandlerDefinition.flatten(delegates);
        this.handlerEnhancerDefinition = handlerEnhancerDefinition;
    }

    private static List<HandlerDefinition> flatten(List<HandlerDefinition> handlerDefinitions) {
        ArrayList<HandlerDefinition> flattened = new ArrayList<HandlerDefinition>(handlerDefinitions.size());
        for (HandlerDefinition handlerDefinition : handlerDefinitions) {
            if (handlerDefinition instanceof MultiHandlerDefinition) {
                flattened.addAll(((MultiHandlerDefinition)handlerDefinition).getDelegates());
                continue;
            }
            flattened.add(handlerDefinition);
        }
        flattened.sort(PriorityAnnotationComparator.getInstance());
        return flattened;
    }

    public List<HandlerDefinition> getDelegates() {
        return Collections.unmodifiableList(this.handlerDefinitions);
    }

    public HandlerEnhancerDefinition getHandlerEnhancerDefinition() {
        return this.handlerEnhancerDefinition;
    }

    @Override
    public <T> Optional<MessageHandlingMember<T>> createHandler(@Nonnull Class<T> declaringType, @Nonnull Method method, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull Function<Object, MessageStream<?>> returnTypeConverter) {
        Optional<MessageHandlingMember<Object>> handler = Optional.empty();
        for (HandlerDefinition handlerDefinition : this.handlerDefinitions) {
            handler = handlerDefinition.createHandler(declaringType, method, parameterResolverFactory, returnTypeConverter);
            if (!handler.isPresent()) continue;
            return Optional.of(this.handlerEnhancerDefinition.wrapHandler(handler.get()));
        }
        return handler;
    }
}

