/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

public interface Message<P> {
    public String getIdentifier();

    @Nonnull
    public MessageType type();

    public MetaData getMetaData();

    public P getPayload();

    @Deprecated
    public Class<P> getPayloadType();

    public Message<P> withMetaData(@Nonnull Map<String, ?> var1);

    public Message<P> andMetaData(@Nonnull Map<String, ?> var1);

    @Deprecated
    default public <R> SerializedObject<R> serializePayload(Serializer serializer, Class<R> expectedRepresentation) {
        return serializer.serialize(this.getPayload(), expectedRepresentation);
    }

    @Deprecated
    default public <R> SerializedObject<R> serializeMetaData(Serializer serializer, Class<R> expectedRepresentation) {
        return serializer.serialize(this.getMetaData(), expectedRepresentation);
    }

    default public <C> Message<C> withConvertedPayload(@Nonnull Function<P, C> conversion) {
        if (Objects.equals(this.getPayload(), conversion.apply(this.getPayload()))) {
            return this;
        }
        throw new UnsupportedOperationException("To be implemented");
    }
}

