/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.messaging.AbstractMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedObjectHolder;
import org.axonframework.serialization.Serializer;

public class GenericMessage<P>
extends AbstractMessage<P> {
    private final P payload;
    private final MetaData metaData;
    private volatile transient SerializedObjectHolder serializedObjectHolder;
    @Deprecated
    private final Class<P> payloadType;

    public GenericMessage(@Nonnull MessageType type, @Nullable P payload) {
        this(type, payload, MetaData.emptyInstance());
    }

    public GenericMessage(@Nonnull MessageType type, @Nullable P payload, @Nonnull Map<String, ?> metaData) {
        this(type, payload, metaData, GenericMessage.getDeclaredPayloadType(payload));
    }

    @Deprecated
    public GenericMessage(@Nonnull MessageType type, @Nullable P payload, @Nonnull Map<String, ?> metaData, @Deprecated Class<P> declaredPayloadType) {
        this(IdentifierFactory.getInstance().generateIdentifier(), type, payload, CurrentUnitOfWork.correlationData().mergedWith(MetaData.from(metaData)), declaredPayloadType);
    }

    public GenericMessage(@Nonnull String identifier, @Nonnull MessageType type, @Nullable P payload, @Nonnull Map<String, ?> metaData) {
        this(identifier, type, payload, metaData, GenericMessage.getDeclaredPayloadType(payload));
    }

    @Deprecated
    public GenericMessage(@Nonnull String identifier, @Nonnull MessageType type, @Nullable P payload, @Nonnull Map<String, ?> metaData, @Deprecated Class<P> declaredPayloadType) {
        super(identifier, type);
        this.payload = payload;
        this.metaData = MetaData.from(metaData);
        this.payloadType = declaredPayloadType;
    }

    private GenericMessage(@Nonnull GenericMessage<P> original, @Nonnull MetaData metaData) {
        super(original.getIdentifier(), original.type());
        this.payload = original.getPayload();
        this.metaData = metaData;
        this.payloadType = original.getPayloadType();
    }

    @Deprecated
    private static <T> Class<T> getDeclaredPayloadType(T payload) {
        return payload != null ? payload.getClass() : Void.class;
    }

    public static Message<Void> emptyMessage() {
        return new GenericMessage<Object>(new MessageType("empty"), null);
    }

    @Override
    public MetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public P getPayload() {
        return this.payload;
    }

    @Override
    public Class<P> getPayloadType() {
        return this.payloadType;
    }

    @Override
    protected Message<P> withMetaData(MetaData metaData) {
        return new GenericMessage<P>(this, metaData);
    }

    @Override
    public <R> SerializedObject<R> serializePayload(Serializer serializer, Class<R> expectedRepresentation) {
        return this.serializedObjectHolder().serializePayload(serializer, expectedRepresentation);
    }

    @Override
    public <R> SerializedObject<R> serializeMetaData(Serializer serializer, Class<R> expectedRepresentation) {
        return this.serializedObjectHolder().serializeMetaData(serializer, expectedRepresentation);
    }

    private SerializedObjectHolder serializedObjectHolder() {
        if (this.serializedObjectHolder == null) {
            this.serializedObjectHolder = new SerializedObjectHolder(this);
        }
        return this.serializedObjectHolder;
    }
}

