/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import java.util.Map;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;

public abstract class AbstractMessage<P>
implements Message<P> {
    private final String identifier;
    private final MessageType type;

    public AbstractMessage(@Nonnull String identifier, @Nonnull MessageType type) {
        this.identifier = identifier;
        this.type = type;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @Nonnull
    public MessageType type() {
        return this.type;
    }

    @Override
    public Message<P> withMetaData(@Nonnull Map<String, ?> metaData) {
        if (this.getMetaData().equals(metaData)) {
            return this;
        }
        return this.withMetaData(MetaData.from(metaData));
    }

    @Override
    public Message<P> andMetaData(@Nonnull Map<String, ?> metaData) {
        if (metaData.isEmpty()) {
            return this;
        }
        return this.withMetaData(this.getMetaData().mergedWith(metaData));
    }

    protected abstract Message<P> withMetaData(MetaData var1);
}

