/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.gateway;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventSink;
import org.axonframework.eventhandling.gateway.EventGateway;
import org.axonframework.eventhandling.gateway.EventPublishingUtils;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.messaging.unitofwork.UnitOfWork;

public class DefaultEventGateway
implements EventGateway {
    private final EventSink eventSink;
    private final MessageTypeResolver messageTypeResolver;

    public DefaultEventGateway(@Nonnull EventSink eventSink, @Nonnull MessageTypeResolver messageTypeResolver) {
        this.eventSink = Objects.requireNonNull(eventSink, "EventSink may not be null");
        this.messageTypeResolver = Objects.requireNonNull(messageTypeResolver, "MessageTypeResolver may not be null");
    }

    @Override
    public void publish(@Nonnull List<?> events) {
        UnitOfWork unitOfWork = new UnitOfWork();
        unitOfWork.onInvocation(context -> {
            this.doPublish(events, (ProcessingContext)context);
            return CompletableFuture.completedFuture(null);
        });
        unitOfWork.execute().join();
    }

    private void doPublish(List<?> events, ProcessingContext context) {
        Objects.requireNonNull(events, "Events may not be null");
        Objects.requireNonNull(context, "Context may not be null");
        List<EventMessage<?>> eventMessages = events.stream().map(e -> EventPublishingUtils.asEventMessage(e, this.messageTypeResolver)).collect(Collectors.toList());
        this.eventSink.publish(context, eventMessages);
    }
}

