/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.jdbc;

import java.util.function.Function;
import org.axonframework.common.BuilderUtils;

public class DeadLetterSchema {
    private final String deadLetterTable;
    private final String deadLetterIdentifierColumn;
    private final String processingGroupColumn;
    private final String sequenceIdentifierColumn;
    private final String sequenceIndexColumn;
    private final String eventTypeColumn;
    private final String eventIdentifierColumn;
    private final String typeColumn;
    private final String timestampColumn;
    private final String payloadTypeColumn;
    private final String payloadRevisionColumn;
    private final String payloadColumn;
    private final String metaDataColumn;
    private final String aggregateTypeColumn;
    private final String aggregateIdentifierColumn;
    private final String sequenceNumberColumn;
    private final String tokenTypeColumn;
    private final String tokenColumn;
    private final String enqueuedAtColumn;
    private final String lastTouchedColumn;
    private final String processingStartedColumn;
    private final String causeTypeColumn;
    private final String causeMessageColumn;
    private final String diagnosticsColumn;
    private final Function<DeadLetterSchema, String> deadLetterFields = schema -> String.join((CharSequence)",", schema.deadLetterIdentifierColumn(), schema.processingGroupColumn(), schema.sequenceIdentifierColumn(), schema.sequenceIndexColumn(), schema.eventTypeColumn(), schema.eventIdentifierColumn(), schema.typeColumn(), schema.timestampColumn(), schema.payloadTypeColumn(), schema.payloadRevisionColumn(), schema.payloadColumn(), schema.metaDataColumn(), schema.aggregateTypeColumn(), schema.aggregateIdentifierColumn(), schema.sequenceNumberColumn(), schema.tokenTypeColumn(), schema.tokenColumn(), schema.enqueuedAtColumn(), schema.lastTouchedColumn(), schema.causeTypeColumn(), schema.causeMessageColumn(), schema.diagnosticsColumn());

    protected DeadLetterSchema(Builder builder) {
        this.deadLetterTable = builder.deadLetterTable;
        this.deadLetterIdentifierColumn = builder.deadLetterIdentifierColumn;
        this.processingGroupColumn = builder.processingGroupColumn;
        this.sequenceIdentifierColumn = builder.sequenceIdentifierColumn;
        this.sequenceIndexColumn = builder.sequenceIndexColumn;
        this.eventTypeColumn = builder.eventTypeColumn;
        this.eventIdentifierColumn = builder.eventIdentifierColumn;
        this.typeColumn = builder.typeColumn;
        this.timestampColumn = builder.timeStampColumn;
        this.payloadTypeColumn = builder.payloadTypeColumn;
        this.payloadRevisionColumn = builder.payloadRevisionColumn;
        this.payloadColumn = builder.payloadColumn;
        this.metaDataColumn = builder.metaDataColumn;
        this.aggregateTypeColumn = builder.aggregateTypeColumn;
        this.aggregateIdentifierColumn = builder.aggregateIdentifierColumn;
        this.sequenceNumberColumn = builder.sequenceNumberColumn;
        this.tokenTypeColumn = builder.tokenTypeColumn;
        this.tokenColumn = builder.tokenColumn;
        this.enqueuedAtColumn = builder.enqueuedAtColumn;
        this.lastTouchedColumn = builder.lastTouchedColumn;
        this.processingStartedColumn = builder.processingStartedColumn;
        this.causeTypeColumn = builder.causeTypeColumn;
        this.causeMessageColumn = builder.causeMessageColumn;
        this.diagnosticsColumn = builder.diagnosticsColumn;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DeadLetterSchema defaultSchema() {
        return DeadLetterSchema.builder().build();
    }

    public String deadLetterTable() {
        return this.deadLetterTable;
    }

    public String deadLetterIdentifierColumn() {
        return this.deadLetterIdentifierColumn;
    }

    public String processingGroupColumn() {
        return this.processingGroupColumn;
    }

    public String sequenceIdentifierColumn() {
        return this.sequenceIdentifierColumn;
    }

    public String sequenceIndexColumn() {
        return this.sequenceIndexColumn;
    }

    public String eventTypeColumn() {
        return this.eventTypeColumn;
    }

    public String eventIdentifierColumn() {
        return this.eventIdentifierColumn;
    }

    public String typeColumn() {
        return this.typeColumn;
    }

    public String timestampColumn() {
        return this.timestampColumn;
    }

    public String payloadTypeColumn() {
        return this.payloadTypeColumn;
    }

    public String payloadRevisionColumn() {
        return this.payloadRevisionColumn;
    }

    public String payloadColumn() {
        return this.payloadColumn;
    }

    public String metaDataColumn() {
        return this.metaDataColumn;
    }

    public String aggregateTypeColumn() {
        return this.aggregateTypeColumn;
    }

    public String aggregateIdentifierColumn() {
        return this.aggregateIdentifierColumn;
    }

    public String sequenceNumberColumn() {
        return this.sequenceNumberColumn;
    }

    public String tokenTypeColumn() {
        return this.tokenTypeColumn;
    }

    public String tokenColumn() {
        return this.tokenColumn;
    }

    public String enqueuedAtColumn() {
        return this.enqueuedAtColumn;
    }

    public String lastTouchedColumn() {
        return this.lastTouchedColumn;
    }

    public String processingStartedColumn() {
        return this.processingStartedColumn;
    }

    public String causeTypeColumn() {
        return this.causeTypeColumn;
    }

    public String causeMessageColumn() {
        return this.causeMessageColumn;
    }

    public String diagnosticsColumn() {
        return this.diagnosticsColumn;
    }

    public String deadLetterFields() {
        return this.deadLetterFields.apply(this);
    }

    public static class Builder {
        private String deadLetterTable = "DeadLetterEntry";
        private String deadLetterIdentifierColumn = "deadLetterIdentifier";
        private String processingGroupColumn = "processingGroup";
        private String sequenceIdentifierColumn = "sequenceIdentifier";
        private String sequenceIndexColumn = "sequenceIndex";
        private String eventTypeColumn = "eventType";
        private String eventIdentifierColumn = "eventIdentifier";
        private String typeColumn = "type";
        private String timeStampColumn = "timestamp";
        private String payloadTypeColumn = "payloadType";
        private String payloadRevisionColumn = "payloadRevision";
        private String payloadColumn = "payload";
        private String metaDataColumn = "metaData";
        private String aggregateTypeColumn = "aggregateType";
        private String aggregateIdentifierColumn = "aggregateIdentifier";
        private String sequenceNumberColumn = "sequenceNumber";
        private String tokenTypeColumn = "tokenType";
        private String tokenColumn = "token";
        private String enqueuedAtColumn = "enqueuedAt";
        private String lastTouchedColumn = "lastTouched";
        private String processingStartedColumn = "processingStarted";
        private String causeTypeColumn = "causeType";
        private String causeMessageColumn = "causeMessage";
        private String diagnosticsColumn = "diagnostics";

        public Builder deadLetterTable(String deadLetterTable) {
            BuilderUtils.assertNonEmpty(deadLetterTable, "The DeadLetterEntryColumn should be not null or empty");
            this.deadLetterTable = deadLetterTable;
            return this;
        }

        public Builder deadLetterIdentifierColumn(String deadLetterIdentifierColumn) {
            BuilderUtils.assertNonEmpty(deadLetterIdentifierColumn, "The deadLetterIdentifierColumn should be not null or empty");
            this.deadLetterIdentifierColumn = deadLetterIdentifierColumn;
            return this;
        }

        public Builder processingGroupColumn(String processingGroupColumn) {
            BuilderUtils.assertNonEmpty(processingGroupColumn, "The processingGroupColumn should be not null or empty");
            this.processingGroupColumn = processingGroupColumn;
            return this;
        }

        public Builder sequenceIdentifierColumn(String sequenceIdentifierColumn) {
            BuilderUtils.assertNonEmpty(sequenceIdentifierColumn, "The sequenceIdentifierColumn should be not null or empty");
            this.sequenceIdentifierColumn = sequenceIdentifierColumn;
            return this;
        }

        public Builder sequenceIndexColumn(String sequenceIndexColumn) {
            BuilderUtils.assertNonEmpty(sequenceIndexColumn, "The sequenceIndexColumn should be not null or empty");
            this.sequenceIndexColumn = sequenceIndexColumn;
            return this;
        }

        public Builder eventTypeColumn(String eventTypeColumn) {
            BuilderUtils.assertNonEmpty(eventTypeColumn, "The eventTypeColumn should be not null or empty");
            this.eventTypeColumn = eventTypeColumn;
            return this;
        }

        public Builder eventIdentifierColumn(String eventIdentifierColumn) {
            BuilderUtils.assertNonEmpty(eventIdentifierColumn, "The eventIdentifierColumn should be not null or empty");
            this.eventIdentifierColumn = eventIdentifierColumn;
            return this;
        }

        public Builder typeColumn(String typeColumn) {
            BuilderUtils.assertNonEmpty(typeColumn, "The typeColumn should be not null or empty");
            this.typeColumn = typeColumn;
            return this;
        }

        public Builder timestampColumn(String timestampColumn) {
            BuilderUtils.assertNonEmpty(timestampColumn, "The timestampColumn should be not null or empty");
            this.timeStampColumn = timestampColumn;
            return this;
        }

        public Builder payloadTypeColumn(String payloadTypeColumn) {
            BuilderUtils.assertNonEmpty(payloadTypeColumn, "The payloadTypeColumn should be not null or empty");
            this.payloadTypeColumn = payloadTypeColumn;
            return this;
        }

        public Builder payloadRevisionColumn(String payloadRevisionColumn) {
            BuilderUtils.assertNonEmpty(payloadRevisionColumn, "The payloadRevisionColumn should be not null or empty");
            this.payloadRevisionColumn = payloadRevisionColumn;
            return this;
        }

        public Builder payloadColumn(String payloadColumn) {
            BuilderUtils.assertNonEmpty(payloadColumn, "The payloadColumn should be not null or empty");
            this.payloadColumn = payloadColumn;
            return this;
        }

        public Builder metaDataColumn(String metaDataColumn) {
            BuilderUtils.assertNonEmpty(metaDataColumn, "The metaDataColumn should be not null or empty");
            this.metaDataColumn = metaDataColumn;
            return this;
        }

        public Builder aggregateTypeColumn(String aggregateTypeColumn) {
            BuilderUtils.assertNonEmpty(aggregateTypeColumn, "The aggregateTypeColumn should be not null or empty");
            this.aggregateTypeColumn = aggregateTypeColumn;
            return this;
        }

        public Builder aggregateIdentifierColumn(String aggregateIdentifierColumn) {
            BuilderUtils.assertNonEmpty(aggregateIdentifierColumn, "The aggregateIdentifierColumn should be not null or empty");
            this.aggregateIdentifierColumn = aggregateIdentifierColumn;
            return this;
        }

        public Builder sequenceNumberColumn(String sequenceNumberColumn) {
            BuilderUtils.assertNonEmpty(sequenceNumberColumn, "The sequenceNumberColumn should be not null or empty");
            this.sequenceNumberColumn = sequenceNumberColumn;
            return this;
        }

        public Builder tokenTypeColumn(String tokenTypeColumn) {
            BuilderUtils.assertNonEmpty(tokenTypeColumn, "The tokenTypeColumn should be not null or empty");
            this.tokenTypeColumn = tokenTypeColumn;
            return this;
        }

        public Builder tokenColumn(String tokenColumn) {
            BuilderUtils.assertNonEmpty(tokenColumn, "The tokenColumn should be not null or empty");
            this.tokenColumn = tokenColumn;
            return this;
        }

        public Builder enqueuedAtColumn(String enqueuedAtColumn) {
            BuilderUtils.assertNonEmpty(enqueuedAtColumn, "The enqueuedAtColumn should be not null or empty");
            this.enqueuedAtColumn = enqueuedAtColumn;
            return this;
        }

        public Builder lastTouchedColumn(String lastTouchedColumn) {
            BuilderUtils.assertNonEmpty(lastTouchedColumn, "The lastTouchedColumn should be not null or empty");
            this.lastTouchedColumn = lastTouchedColumn;
            return this;
        }

        public Builder processingStartedColumn(String processingStartedColumn) {
            BuilderUtils.assertNonEmpty(processingStartedColumn, "The processingStartedColumn should be not null or empty");
            this.processingStartedColumn = processingStartedColumn;
            return this;
        }

        public Builder causeTypeColumn(String causeTypeColumn) {
            BuilderUtils.assertNonEmpty(causeTypeColumn, "The causeTypeColumn should be not null or empty");
            this.causeTypeColumn = causeTypeColumn;
            return this;
        }

        public Builder causeMessageColumn(String causeMessageColumn) {
            BuilderUtils.assertNonEmpty(causeMessageColumn, "The causeMessageColumn should be not null or empty");
            this.causeMessageColumn = causeMessageColumn;
            return this;
        }

        public Builder diagnosticsColumn(String diagnosticsColumn) {
            BuilderUtils.assertNonEmpty(diagnosticsColumn, "The diagnosticsColumn should be not null or empty");
            this.diagnosticsColumn = diagnosticsColumn;
            return this;
        }

        public DeadLetterSchema build() {
            return new DeadLetterSchema(this);
        }
    }
}

