/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.Objects;
import java.util.OptionalLong;
import org.axonframework.eventhandling.EventTrackerStatus;
import org.axonframework.eventhandling.MergedTrackingToken;
import org.axonframework.eventhandling.ReplayToken;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.WrappedToken;

public final class TrackerStatus
implements EventTrackerStatus {
    private final Segment segment;
    private final boolean caughtUp;
    private final TrackingToken trackingToken;
    private final Throwable errorState;

    public TrackerStatus(Segment segment, TrackingToken trackingToken) {
        this(segment, false, trackingToken, null);
    }

    public TrackerStatus(Segment segment, boolean caughtUp, TrackingToken trackingToken, Throwable errorState) {
        this.segment = segment;
        this.caughtUp = caughtUp;
        this.trackingToken = trackingToken;
        this.errorState = errorState;
    }

    public TrackerStatus caughtUp() {
        return this.caughtUp ? this : new TrackerStatus(this.segment, true, this.trackingToken, null);
    }

    public TrackerStatus advancedTo(TrackingToken trackingToken) {
        return Objects.equals(this.trackingToken, trackingToken) ? this : new TrackerStatus(this.segment, this.caughtUp, trackingToken, null);
    }

    public TrackerStatus markError(Throwable error) {
        return new TrackerStatus(this.segment, this.caughtUp, this.trackingToken, error);
    }

    public TrackerStatus unmarkError() {
        return new TrackerStatus(this.segment, this.caughtUp, this.trackingToken, null);
    }

    public TrackingToken getInternalTrackingToken() {
        return this.trackingToken;
    }

    public TrackerStatus[] split() {
        return TrackerStatus.split(this.segment, this.trackingToken);
    }

    public static TrackerStatus[] split(Segment segment, TrackingToken trackingToken) {
        Segment[] newSegments = segment.split();
        TrackingToken tokenAtReset = null;
        TrackingToken workingToken = trackingToken;
        TrackingToken[] splitTokens = new TrackingToken[2];
        if (workingToken instanceof ReplayToken) {
            tokenAtReset = ((ReplayToken)workingToken).getTokenAtReset();
            workingToken = ((ReplayToken)workingToken).lowerBound();
        }
        if (workingToken instanceof MergedTrackingToken) {
            splitTokens[0] = ((MergedTrackingToken)workingToken).lowerSegmentToken();
            splitTokens[1] = ((MergedTrackingToken)workingToken).upperSegmentToken();
        } else {
            splitTokens[0] = workingToken;
            splitTokens[1] = workingToken;
        }
        if (tokenAtReset != null) {
            splitTokens[0] = ReplayToken.createReplayToken(tokenAtReset, splitTokens[0]);
            splitTokens[1] = ReplayToken.createReplayToken(tokenAtReset, splitTokens[1]);
        }
        TrackerStatus[] newStatus = new TrackerStatus[]{new TrackerStatus(newSegments[0], splitTokens[0]), new TrackerStatus(newSegments[1], splitTokens[1])};
        return newStatus;
    }

    @Override
    public Segment getSegment() {
        return this.segment;
    }

    @Override
    public boolean isCaughtUp() {
        return this.caughtUp;
    }

    @Override
    public boolean isReplaying() {
        return ReplayToken.isReplay(this.trackingToken);
    }

    @Override
    public boolean isMerging() {
        return MergedTrackingToken.isMergeInProgress(this.trackingToken);
    }

    @Override
    public OptionalLong mergeCompletedPosition() {
        return MergedTrackingToken.mergePosition(this.trackingToken);
    }

    @Override
    public TrackingToken getTrackingToken() {
        return WrappedToken.unwrapLowerBound(this.trackingToken);
    }

    @Override
    public boolean isErrorState() {
        return this.errorState != null;
    }

    @Override
    public Throwable getError() {
        return this.errorState;
    }

    @Override
    public OptionalLong getCurrentPosition() {
        if (this.isReplaying()) {
            return WrappedToken.unwrap(this.trackingToken, ReplayToken.class).map(ReplayToken::position).orElse(OptionalLong.empty());
        }
        if (this.isMerging()) {
            return WrappedToken.unwrap(this.trackingToken, MergedTrackingToken.class).map(MergedTrackingToken::position).orElse(OptionalLong.empty());
        }
        return this.trackingToken == null ? OptionalLong.empty() : this.trackingToken.position();
    }

    @Override
    public OptionalLong getResetPosition() {
        return ReplayToken.getTokenAtReset(this.trackingToken);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackerStatus that = (TrackerStatus)o;
        return this.caughtUp == that.caughtUp && Objects.equals(this.segment, that.segment) && Objects.equals(this.trackingToken, that.trackingToken) && Objects.equals(this.errorState, that.errorState);
    }

    public int hashCode() {
        return Objects.hash(this.segment, this.caughtUp, this.trackingToken, this.errorState);
    }

    public String toString() {
        return "TrackerStatus{segment=" + String.valueOf(this.getSegment()) + ", caughtUp=" + this.isCaughtUp() + ", replaying=" + this.isReplaying() + ", merging=" + this.isMerging() + ", errorState=" + this.isErrorState() + ", error=" + String.valueOf(this.getError()) + ", trackingToken=" + String.valueOf(this.getTrackingToken()) + ", currentPosition=" + String.valueOf(this.getCurrentPosition()) + ", resetPosition=" + String.valueOf(this.getResetPosition()) + ", mergeCompletedPosition=" + String.valueOf(this.mergeCompletedPosition()) + "}";
    }
}

