/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.axonframework.common.Assert;

public class Segment
implements Comparable<Segment> {
    private static final Segment[] EMPTY_SEGMENTS = new Segment[0];
    private static final int ZERO_MASK = 0;
    public static final Segment ROOT_SEGMENT = new Segment(0, 0);
    private final int segmentId;
    private final int mask;

    private static boolean computeSegments(Segment segment, List<Integer> segments, Set<Segment> applicableSegments) {
        Segment[] splitSegment = segment.split();
        if (segments.contains(splitSegment[1].getSegmentId())) {
            for (Segment segmentSplit : splitSegment) {
                if (Segment.computeSegments(segmentSplit, segments, applicableSegments)) continue;
                applicableSegments.add(segmentSplit);
            }
        } else {
            applicableSegments.add(segment);
        }
        return true;
    }

    public static Segment[] computeSegments(int ... segments) {
        if (segments == null || segments.length == 0) {
            return EMPTY_SEGMENTS;
        }
        HashSet<Segment> resolvedSegments = new HashSet<Segment>();
        Segment.computeSegments(ROOT_SEGMENT, Arrays.stream(segments).boxed().collect(Collectors.toList()), resolvedSegments);
        return resolvedSegments.stream().sorted().collect(Collectors.toList()).toArray(new Segment[resolvedSegments.size()]);
    }

    public static Segment computeSegment(int segmentId, int ... availableSegmentIds) {
        int splitCandidate;
        Arrays.sort(availableSegmentIds);
        int n = splitCandidate = segmentId == 0 ? 1 : Integer.highestOneBit(segmentId) << 1;
        while (Arrays.binarySearch(availableSegmentIds, splitCandidate | segmentId) >= 0) {
            splitCandidate <<= 1;
        }
        int mask = splitCandidate - 1;
        return new Segment(segmentId, mask);
    }

    public static List<Segment> splitBalanced(Segment segment, int numberOfTimes) {
        TreeSet<Segment> toBeSplit = new TreeSet<Segment>(Comparator.comparing(Segment::getMask).thenComparing(Segment::getSegmentId));
        toBeSplit.add(segment);
        for (int i = 0; i < numberOfTimes; ++i) {
            Segment workingSegment = (Segment)toBeSplit.first();
            toBeSplit.remove(workingSegment);
            toBeSplit.addAll(Arrays.asList(workingSegment.split()));
        }
        ArrayList<Segment> result = new ArrayList<Segment>(toBeSplit);
        result.sort(Comparator.comparing(Segment::getSegmentId));
        return result;
    }

    protected Segment(int segmentId, int mask) {
        Assert.isTrue(mask == 0 || mask + 1 == Integer.highestOneBit(mask + 1), () -> "Invalid mask. It must end on a consecutive series of 1s");
        this.segmentId = segmentId;
        this.mask = mask;
    }

    public Segment mergedWith(Segment other) {
        Assert.isTrue(this.isMergeableWith(other), () -> "Given " + String.valueOf(other) + " cannot be merged with " + String.valueOf(this));
        return new Segment(Math.min(this.segmentId, other.segmentId), this.mask >>> 1);
    }

    public int mergeableSegmentId() {
        int parentMask = this.mask >>> 1;
        int firstBit = this.mask ^ parentMask;
        return this.segmentId ^ firstBit;
    }

    public boolean isMergeableWith(Segment other) {
        return this.mask == other.mask && this.mergeableSegmentId() == other.getSegmentId();
    }

    public int getSegmentId() {
        return this.segmentId;
    }

    public int getMask() {
        return this.mask;
    }

    public boolean matches(int value) {
        return this.mask == 0 || (this.mask & value) == this.segmentId;
    }

    public boolean matches(Object value) {
        return this.mask == 0 || this.matches(Objects.hashCode(value));
    }

    public Segment[] split() {
        if (this.mask << 1 < 0) {
            throw new IllegalStateException("Unable to split the given segmentId, as the mask exceeds the max mask size.");
        }
        Segment[] segments = new Segment[2];
        int newMask = (this.mask << 1) + 1;
        int newSegment = this.segmentId + (this.mask == 0 ? 1 : newMask ^ this.mask);
        segments[0] = new Segment(this.segmentId, newMask);
        segments[1] = new Segment(newSegment, newMask);
        return segments;
    }

    public int splitSegmentId() {
        return this.segmentId + (this.mask == 0 ? 1 : (this.mask << 1) + 1 ^ this.mask);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Segment that = (Segment)o;
        return this.segmentId == that.segmentId && this.mask == that.mask;
    }

    public String toString() {
        return String.format("Segment[%d/%s]", this.getSegmentId(), this.getMask());
    }

    public int hashCode() {
        return Objects.hash(this.segmentId, this.mask);
    }

    @Override
    public int compareTo(Segment that) {
        return Integer.compare(this.segmentId, that.segmentId);
    }
}

