/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.WrappedToken;
import org.axonframework.messaging.Message;

public class ReplayToken
implements TrackingToken,
WrappedToken {
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@class")
    private final TrackingToken tokenAtReset;
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@class")
    private final TrackingToken currentToken;
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@class")
    private final Object context;
    private final transient boolean lastMessageWasReplay;

    @JsonCreator
    @ConstructorProperties(value={"tokenAtReset", "currentToken", "resetContext"})
    ReplayToken(@JsonProperty(value="tokenAtReset") TrackingToken tokenAtReset, @JsonProperty(value="currentToken") TrackingToken newRedeliveryToken, @JsonProperty(value="resetContext") Object resetContext) {
        this(tokenAtReset, newRedeliveryToken, resetContext, true);
    }

    private ReplayToken(TrackingToken tokenAtReset, TrackingToken newRedeliveryToken, Object context, boolean lastMessageWasReplay) {
        this.tokenAtReset = tokenAtReset;
        this.currentToken = newRedeliveryToken;
        this.context = context;
        this.lastMessageWasReplay = lastMessageWasReplay;
    }

    public static boolean isReplay(Message<?> message) {
        return message instanceof TrackedEventMessage && ReplayToken.isReplay(((TrackedEventMessage)message).trackingToken());
    }

    public static TrackingToken createReplayToken(TrackingToken tokenAtReset, @Nullable TrackingToken startPosition) {
        return ReplayToken.createReplayToken(tokenAtReset, startPosition, null);
    }

    public static TrackingToken createReplayToken(TrackingToken tokenAtReset, TrackingToken startPosition, Object resetContext) {
        if (tokenAtReset == null) {
            return startPosition;
        }
        if (tokenAtReset instanceof ReplayToken) {
            return ReplayToken.createReplayToken(((ReplayToken)tokenAtReset).tokenAtReset, startPosition, resetContext);
        }
        if (startPosition != null && startPosition.covers(WrappedToken.unwrapLowerBound(tokenAtReset))) {
            return startPosition;
        }
        return new ReplayToken(tokenAtReset, startPosition, resetContext);
    }

    public static TrackingToken createReplayToken(TrackingToken tokenAtReset) {
        return ReplayToken.createReplayToken(tokenAtReset, null);
    }

    public static <T> Optional<T> replayContext(EventMessage<?> message, @Nonnull Class<T> contextClass) {
        if (message instanceof TrackedEventMessage) {
            return ReplayToken.replayContext(((TrackedEventMessage)message).trackingToken(), contextClass);
        }
        return Optional.empty();
    }

    public static boolean isReplay(TrackingToken trackingToken) {
        return WrappedToken.unwrap(trackingToken, ReplayToken.class).map(rt -> rt.isReplay()).orElse(false);
    }

    public static <T> Optional<T> replayContext(TrackingToken trackingToken, @Nonnull Class<T> contextClass) {
        return WrappedToken.unwrap(trackingToken, ReplayToken.class).map(ReplayToken::context).filter(c -> c.getClass().isAssignableFrom(contextClass)).map(contextClass::cast);
    }

    public static OptionalLong getTokenAtReset(TrackingToken trackingToken) {
        return WrappedToken.unwrap(trackingToken, ReplayToken.class).map(rt -> rt.getTokenAtReset().position()).orElse(OptionalLong.empty());
    }

    public TrackingToken getTokenAtReset() {
        return this.tokenAtReset;
    }

    public TrackingToken getCurrentToken() {
        return this.currentToken;
    }

    @Override
    public TrackingToken advancedTo(TrackingToken newToken) {
        if (this.tokenAtReset == null || newToken.covers(WrappedToken.unwrapUpperBound(this.tokenAtReset)) && !this.tokenAtReset.covers(WrappedToken.unwrapLowerBound(newToken))) {
            if (this.tokenAtReset instanceof WrappedToken) {
                return ((WrappedToken)this.tokenAtReset).advancedTo(newToken);
            }
            return newToken;
        }
        if (this.tokenAtReset.covers(WrappedToken.unwrapLowerBound(newToken))) {
            return new ReplayToken(this.tokenAtReset, newToken, this.context, true);
        }
        if (this.tokenAtReset instanceof WrappedToken) {
            return new ReplayToken(this.tokenAtReset.upperBound(newToken), ((WrappedToken)this.tokenAtReset).advancedTo(newToken), this.context, false);
        }
        return new ReplayToken(this.tokenAtReset.upperBound(newToken), newToken, this.context, false);
    }

    @Override
    public TrackingToken lowerBound(TrackingToken other) {
        if (other instanceof ReplayToken) {
            return new ReplayToken(this, ((ReplayToken)other).currentToken, this.context);
        }
        return new ReplayToken(this, other, this.context);
    }

    @Override
    public TrackingToken upperBound(TrackingToken other) {
        return this.advancedTo(other);
    }

    @Override
    public boolean covers(TrackingToken other) {
        if (other instanceof ReplayToken) {
            return this.currentToken != null && this.currentToken.covers(((ReplayToken)other).currentToken);
        }
        return this.currentToken != null && this.currentToken.covers(other);
    }

    private boolean isReplay() {
        return this.lastMessageWasReplay;
    }

    @Override
    public TrackingToken lowerBound() {
        return WrappedToken.unwrapLowerBound(this.currentToken);
    }

    @Override
    public TrackingToken upperBound() {
        return WrappedToken.unwrapUpperBound(this.currentToken);
    }

    @Override
    public <R extends TrackingToken> Optional<R> unwrap(Class<R> tokenType) {
        if (tokenType.isInstance(this)) {
            return Optional.of((TrackingToken)tokenType.cast(this));
        }
        return WrappedToken.unwrap(this.currentToken, tokenType);
    }

    @Nullable
    public Object context() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplayToken that = (ReplayToken)o;
        return Objects.equals(this.tokenAtReset, that.tokenAtReset) && Objects.equals(this.currentToken, that.currentToken) && Objects.equals(this.context, that.context);
    }

    public int hashCode() {
        return Objects.hash(this.tokenAtReset, this.currentToken, this.context);
    }

    public String toString() {
        return "ReplayToken{currentToken=" + String.valueOf(this.currentToken) + ", tokenAtReset=" + String.valueOf(this.tokenAtReset) + ", context=" + (this.context != null ? this.context.toString() : null) + "}";
    }

    @Override
    public OptionalLong position() {
        if (this.currentToken != null) {
            return this.currentToken.position();
        }
        return OptionalLong.of(0L);
    }
}

