/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.eventhandling.DefaultEventProcessorSpanFactory;
import org.axonframework.eventhandling.ErrorContext;
import org.axonframework.eventhandling.ErrorHandler;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventProcessor;
import org.axonframework.eventhandling.EventProcessorSpanFactory;
import org.axonframework.eventhandling.PropagatingErrorHandler;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.StreamingEventProcessor;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.messaging.unitofwork.LegacyUnitOfWork;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.axonframework.tracing.NoOpSpanFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventProcessor
implements EventProcessor {
    private static final List<Segment> ROOT_SEGMENT = Collections.singletonList(Segment.ROOT_SEGMENT);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String name;
    private final EventHandlerInvoker eventHandlerInvoker;
    private final RollbackConfiguration rollbackConfiguration;
    private final ErrorHandler errorHandler;
    private final MessageMonitor<? super EventMessage<?>> messageMonitor;
    private final List<MessageHandlerInterceptor<? super EventMessage<?>>> interceptors = new CopyOnWriteArrayList();
    protected final EventProcessorSpanFactory spanFactory;

    protected AbstractEventProcessor(Builder builder) {
        builder.validate();
        this.name = builder.name;
        this.eventHandlerInvoker = builder.eventHandlerInvoker;
        this.rollbackConfiguration = builder.rollbackConfiguration;
        this.errorHandler = builder.errorHandler;
        this.messageMonitor = builder.messageMonitor;
        this.spanFactory = builder.spanFactory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Registration registerHandlerInterceptor(@Nonnull MessageHandlerInterceptor<? super EventMessage<?>> interceptor) {
        this.interceptors.add(interceptor);
        return () -> this.interceptors.remove(interceptor);
    }

    @Override
    public List<MessageHandlerInterceptor<? super EventMessage<?>>> getHandlerInterceptors() {
        return Collections.unmodifiableList(this.interceptors);
    }

    public String toString() {
        return this.getName();
    }

    protected boolean canHandle(EventMessage<?> eventMessage, Segment segment) throws Exception {
        try {
            return this.eventHandlerInvoker.canHandle(eventMessage, segment);
        }
        catch (Exception e) {
            this.errorHandler.handleError(new ErrorContext(this.getName(), e, Collections.singletonList(eventMessage)));
            return false;
        }
    }

    protected boolean canHandleType(Class<?> payloadType) {
        try {
            return this.eventHandlerInvoker.canHandleType(payloadType);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected final void processInUnitOfWork(List<? extends EventMessage<?>> eventMessages, LegacyUnitOfWork<? extends EventMessage<?>> unitOfWork) throws Exception {
        this.processInUnitOfWork(eventMessages, unitOfWork, ROOT_SEGMENT);
    }

    protected void processInUnitOfWork(List<? extends EventMessage<?>> eventMessages, LegacyUnitOfWork<? extends EventMessage<?>> unitOfWork, Collection<Segment> processingSegments) throws Exception {
        this.spanFactory.createBatchSpan(this instanceof StreamingEventProcessor, eventMessages).runCallable(() -> {
            ResultMessage<Object> resultMessage = unitOfWork.executeWithResult(() -> {
                EventMessage message = (EventMessage)unitOfWork.getMessage();
                MessageMonitor.MonitorCallback monitorCallback = this.messageMonitor.onMessageIngested(message);
                return this.spanFactory.createProcessEventSpan(this instanceof StreamingEventProcessor, message).runCallable(() -> new DefaultInterceptorChain(unitOfWork, this.interceptors, m -> this.processMessageInUnitOfWork(processingSegments, (EventMessage<?>)m, null, monitorCallback)).proceedSync());
            }, this.rollbackConfiguration);
            if (resultMessage.isExceptional()) {
                Throwable e = resultMessage.exceptionResult();
                if (unitOfWork.isRolledBack()) {
                    this.errorHandler.handleError(new ErrorContext(this.getName(), e, eventMessages));
                } else {
                    this.logger.info("Exception occurred while processing a message, but unit of work was committed. {}", (Object)e.getClass().getName());
                }
            }
            return null;
        });
    }

    private Object processMessageInUnitOfWork(Collection<Segment> processingSegments, EventMessage<?> message, ProcessingContext processingContext, MessageMonitor.MonitorCallback monitorCallback) throws Exception {
        try {
            for (Segment processingSegment : processingSegments) {
                this.eventHandlerInvoker.handle(message, processingContext, processingSegment);
            }
            monitorCallback.reportSuccess();
            return null;
        }
        catch (Exception exception) {
            monitorCallback.reportFailure(exception);
            throw exception;
        }
    }

    public EventHandlerInvoker eventHandlerInvoker() {
        return this.eventHandlerInvoker;
    }

    protected void reportIgnored(EventMessage<?> eventMessage) {
        this.messageMonitor.onMessageIngested(eventMessage).reportIgnored();
    }

    public static abstract class Builder {
        protected String name;
        private EventHandlerInvoker eventHandlerInvoker;
        private RollbackConfiguration rollbackConfiguration;
        private ErrorHandler errorHandler = PropagatingErrorHandler.INSTANCE;
        private MessageMonitor<? super EventMessage<?>> messageMonitor = NoOpMessageMonitor.INSTANCE;
        private EventProcessorSpanFactory spanFactory = DefaultEventProcessorSpanFactory.builder().spanFactory(NoOpSpanFactory.INSTANCE).build();

        public Builder name(@Nonnull String name) {
            this.assertEventProcessorName(name, "The EventProcessor name may not be null or empty");
            this.name = name;
            return this;
        }

        public Builder eventHandlerInvoker(@Nonnull EventHandlerInvoker eventHandlerInvoker) {
            BuilderUtils.assertNonNull(eventHandlerInvoker, "EventHandlerInvoker may not be null");
            this.eventHandlerInvoker = eventHandlerInvoker;
            return this;
        }

        public Builder rollbackConfiguration(@Nonnull RollbackConfiguration rollbackConfiguration) {
            BuilderUtils.assertNonNull(rollbackConfiguration, "RollbackConfiguration may not be null");
            this.rollbackConfiguration = rollbackConfiguration;
            return this;
        }

        public Builder errorHandler(@Nonnull ErrorHandler errorHandler) {
            BuilderUtils.assertNonNull(errorHandler, "ErrorHandler may not be null");
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder messageMonitor(@Nonnull MessageMonitor<? super EventMessage<?>> messageMonitor) {
            BuilderUtils.assertNonNull(messageMonitor, "MessageMonitor may not be null");
            this.messageMonitor = messageMonitor;
            return this;
        }

        public Builder spanFactory(@Nonnull EventProcessorSpanFactory spanFactory) {
            BuilderUtils.assertNonNull(spanFactory, "SpanFactory may not be null");
            this.spanFactory = spanFactory;
            return this;
        }

        protected void validate() throws AxonConfigurationException {
            this.assertEventProcessorName(this.name, "The EventProcessor name is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.eventHandlerInvoker, "The EventHandlerInvoker is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.rollbackConfiguration, "The RollbackConfiguration is a hard requirement and should be provided");
        }

        private void assertEventProcessorName(String eventProcessorName, String exceptionMessage) {
            BuilderUtils.assertThat(eventProcessorName, name -> Objects.nonNull(name) && !"".equals(name), exceptionMessage);
        }
    }
}

