/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.quartz;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.AxonNonTransientException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ExceptionUtils;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.configuration.LifecycleRegistry;
import org.axonframework.deadline.AbstractDeadlineManager;
import org.axonframework.deadline.DeadlineException;
import org.axonframework.deadline.DeadlineManagerSpanFactory;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.DefaultDeadlineManagerSpanFactory;
import org.axonframework.deadline.quartz.DeadlineJob;
import org.axonframework.lifecycle.Lifecycle;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.ScopeAwareProvider;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.serialization.Serializer;
import org.axonframework.tracing.NoOpSpanFactory;
import org.axonframework.tracing.Span;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzDeadlineManager
extends AbstractDeadlineManager
implements Lifecycle {
    private static final Logger logger = LoggerFactory.getLogger(QuartzDeadlineManager.class);
    private static final String CANCEL_ERROR_MESSAGE = "An error occurred while cancelling a timer for a deadline manager";
    private static final String JOB_NAME_PREFIX = "deadline-";
    private final Scheduler scheduler;
    private final ScopeAwareProvider scopeAwareProvider;
    private final TransactionManager transactionManager;
    private final Serializer serializer;
    private final Predicate<Throwable> refireImmediatelyPolicy;
    private final DeadlineManagerSpanFactory spanFactory;

    public static Builder builder() {
        return new Builder();
    }

    protected QuartzDeadlineManager(Builder builder) {
        builder.validate();
        this.scheduler = builder.scheduler;
        this.scopeAwareProvider = builder.scopeAwareProvider;
        this.transactionManager = builder.transactionManager;
        this.serializer = builder.serializer.get();
        this.refireImmediatelyPolicy = builder.refireImmediatelyPolicy;
        this.spanFactory = builder.spanFactory;
        this.messageTypeResolver = builder.messageTypeResolver;
        try {
            this.initialize();
        }
        catch (SchedulerException e) {
            throw new AxonConfigurationException("Unable to initialize QuartzDeadlineManager", e);
        }
    }

    private void initialize() throws SchedulerException {
        this.scheduler.getContext().put(DeadlineJob.TRANSACTION_MANAGER_KEY, (Object)this.transactionManager);
        this.scheduler.getContext().put(DeadlineJob.SCOPE_AWARE_RESOLVER, (Object)this.scopeAwareProvider);
        this.scheduler.getContext().put(DeadlineJob.JOB_DATA_SERIALIZER, (Object)this.serializer);
        this.scheduler.getContext().put(DeadlineJob.HANDLER_INTERCEPTORS, this.handlerInterceptors());
        this.scheduler.getContext().put("refireImmediatelyPolicy", this.refireImmediatelyPolicy);
        this.scheduler.getContext().put(DeadlineJob.SPAN_FACTORY, (Object)this.spanFactory);
    }

    @Override
    public String schedule(@Nonnull Instant triggerDateTime, @Nonnull String deadlineName, Object messageOrPayload, @Nonnull ScopeDescriptor deadlineScope) {
        DeadlineMessage deadlineMessage = this.asDeadlineMessage(deadlineName, messageOrPayload, triggerDateTime);
        String deadlineId = JOB_NAME_PREFIX + deadlineMessage.getIdentifier();
        Span span = this.spanFactory.createScheduleSpan(deadlineName, deadlineId, deadlineMessage);
        this.runOnPrepareCommitOrNow(span.wrapRunnable(() -> {
            DeadlineMessage interceptedDeadlineMessage = this.processDispatchInterceptors(deadlineMessage);
            try {
                JobDetail jobDetail = this.buildJobDetail(this.spanFactory.propagateContext(interceptedDeadlineMessage), deadlineScope, new JobKey(deadlineId, deadlineName));
                this.scheduler.scheduleJob(jobDetail, QuartzDeadlineManager.buildTrigger(triggerDateTime, jobDetail.getKey()));
            }
            catch (SchedulerException e) {
                throw new DeadlineException("An error occurred while setting a timer for a deadline", e);
            }
        }));
        return deadlineId;
    }

    @Override
    public String schedule(@Nonnull Duration triggerDuration, @Nonnull String deadlineName, Object messageOrPayload, @Nonnull ScopeDescriptor deadlineScope) {
        return this.schedule(Instant.now().plus(triggerDuration), deadlineName, messageOrPayload, deadlineScope);
    }

    @Override
    public void cancelSchedule(@Nonnull String deadlineName, @Nonnull String scheduleId) {
        Span span = this.spanFactory.createCancelScheduleSpan(deadlineName, scheduleId);
        this.runOnPrepareCommitOrNow(span.wrapRunnable(() -> this.cancelSchedule(JobKey.jobKey((String)scheduleId, (String)deadlineName))));
    }

    @Override
    public void cancelAll(@Nonnull String deadlineName) {
        Span span = this.spanFactory.createCancelAllSpan(deadlineName);
        this.runOnPrepareCommitOrNow(span.wrapRunnable(() -> {
            try {
                this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)deadlineName)).forEach(this::cancelSchedule);
            }
            catch (SchedulerException e) {
                throw new DeadlineException(CANCEL_ERROR_MESSAGE, e);
            }
        }));
    }

    @Override
    public void cancelAllWithinScope(@Nonnull String deadlineName, @Nonnull ScopeDescriptor scope) {
        ScopeDescriptor givenScope = (ScopeDescriptor)this.serializer.deserialize(this.serializer.serialize(scope, String.class));
        this.spanFactory.createCancelAllWithinScopeSpan(deadlineName, givenScope).run(() -> {
            try {
                Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)deadlineName));
                for (JobKey jobKey : jobKeys) {
                    JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
                    ScopeDescriptor jobScope = DeadlineJob.DeadlineJobDataBinder.deadlineScope(this.serializer, jobDetail.getJobDataMap());
                    if (!givenScope.equals(jobScope)) continue;
                    this.cancelSchedule(jobKey);
                }
            }
            catch (SchedulerException e) {
                throw new DeadlineException(CANCEL_ERROR_MESSAGE, e);
            }
        });
    }

    private void cancelSchedule(JobKey jobKey) {
        try {
            if (!this.scheduler.deleteJob(jobKey)) {
                logger.warn("The job belonging to this token could not be deleted.");
            }
        }
        catch (SchedulerException e) {
            throw new DeadlineException(CANCEL_ERROR_MESSAGE, e);
        }
    }

    private JobDetail buildJobDetail(DeadlineMessage deadlineMessage, ScopeDescriptor deadlineScope, JobKey jobKey) {
        JobDataMap jobData = DeadlineJob.DeadlineJobDataBinder.toJobData(this.serializer, deadlineMessage, deadlineScope);
        return JobBuilder.newJob(DeadlineJob.class).withDescription(deadlineMessage.getPayloadType().getName()).withIdentity(jobKey).usingJobData(jobData).requestRecovery(true).build();
    }

    private static Trigger buildTrigger(Instant triggerDateTime, JobKey key) {
        return TriggerBuilder.newTrigger().forJob(key).startAt(Date.from(triggerDateTime)).build();
    }

    @Override
    public void registerLifecycleHandlers(@Nonnull LifecycleRegistry lifecycle) {
        lifecycle.onShutdown(0x3FFFFFFF, this::shutdown);
    }

    @Override
    public void shutdown() {
        try {
            this.scheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            throw new DeadlineException("An error occurred while trying to shutdown the deadline manager", e);
        }
    }

    public static class Builder {
        private Scheduler scheduler;
        private ScopeAwareProvider scopeAwareProvider;
        private TransactionManager transactionManager = NoTransactionManager.INSTANCE;
        private Supplier<Serializer> serializer;
        private Predicate<Throwable> refireImmediatelyPolicy = throwable -> !ExceptionUtils.findException(throwable, AxonNonTransientException.class::isInstance).isPresent();
        private DeadlineManagerSpanFactory spanFactory = DefaultDeadlineManagerSpanFactory.builder().spanFactory(NoOpSpanFactory.INSTANCE).build();
        private MessageTypeResolver messageTypeResolver = new ClassBasedMessageTypeResolver();

        public Builder scheduler(Scheduler scheduler) {
            BuilderUtils.assertNonNull(scheduler, "Scheduler may not be null");
            this.scheduler = scheduler;
            return this;
        }

        public Builder scopeAwareProvider(ScopeAwareProvider scopeAwareProvider) {
            BuilderUtils.assertNonNull(scopeAwareProvider, "ScopeAwareProvider may not be null");
            this.scopeAwareProvider = scopeAwareProvider;
            return this;
        }

        public Builder transactionManager(TransactionManager transactionManager) {
            BuilderUtils.assertNonNull(transactionManager, "TransactionManager may not be null");
            this.transactionManager = transactionManager;
            return this;
        }

        public Builder serializer(Serializer serializer) {
            BuilderUtils.assertNonNull(serializer, "Serializer may not be null");
            this.serializer = () -> serializer;
            return this;
        }

        public Builder spanFactory(@Nonnull DeadlineManagerSpanFactory spanFactory) {
            BuilderUtils.assertNonNull(spanFactory, "SpanFactory may not be null");
            this.spanFactory = spanFactory;
            return this;
        }

        public Builder refireImmediatelyPolicy(Predicate<Throwable> refireImmediatelyPolicy) {
            BuilderUtils.assertNonNull(refireImmediatelyPolicy, "The refire policy may not be null");
            this.refireImmediatelyPolicy = refireImmediatelyPolicy;
            return this;
        }

        public Builder messageNameResolver(MessageTypeResolver messageTypeResolver) {
            BuilderUtils.assertNonNull(messageTypeResolver, "MessageNameResolver may not be null");
            this.messageTypeResolver = messageTypeResolver;
            return this;
        }

        public QuartzDeadlineManager build() {
            return new QuartzDeadlineManager(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.scheduler, "The Scheduler is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.scopeAwareProvider, "The ScopeAwareProvider is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.serializer, "The Serializer is a hard requirement and should be provided");
        }
    }
}

