/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Objects;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.configuration.AbstractComponent;
import org.axonframework.configuration.Component;
import org.axonframework.configuration.Configuration;

class InstantiatedComponentDefinition<C>
extends AbstractComponent<C, C> {
    private final C instance;

    InstantiatedComponentDefinition(@Nonnull Component.Identifier<C> identifier, @Nonnull C instance) {
        super(identifier, Collections.emptyList(), Collections.emptyList());
        this.instance = Objects.requireNonNull(instance, "The instance must not be null.");
    }

    @Override
    public C doResolve(@Nonnull Configuration configuration) {
        return this.instance;
    }

    @Override
    public boolean isInstantiated() {
        return true;
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        super.describeTo(descriptor);
        descriptor.describeProperty("instance", this.instance);
    }
}

