/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.axonframework.common.Assert;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.configuration.Component;
import org.axonframework.configuration.ComponentDefinition;
import org.axonframework.configuration.ComponentOverrideException;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.Components;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.configuration.DecoratorDefinition;
import org.axonframework.configuration.DuplicateModuleRegistrationException;
import org.axonframework.configuration.HierarchicalConfiguration;
import org.axonframework.configuration.LazyInitializedComponentDefinition;
import org.axonframework.configuration.LifecycleRegistry;
import org.axonframework.configuration.Module;
import org.axonframework.configuration.OverridePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComponentRegistry
implements ComponentRegistry {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Components components = new Components();
    private final List<DecoratorDefinition.CompletedDecoratorDefinition<?, ?>> decoratorDefinitions = new ArrayList();
    private final List<ConfigurationEnhancer> enhancers = new ArrayList<ConfigurationEnhancer>();
    private final Map<String, Module> modules = new ConcurrentHashMap<String, Module>();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Map<String, Configuration> moduleConfigurations = new ConcurrentHashMap<String, Configuration>();
    private OverridePolicy overridePolicy = OverridePolicy.WARN;
    private boolean enhancerScanning = true;
    private final List<Class<? extends ConfigurationEnhancer>> disabledEnhancers = new ArrayList<Class<? extends ConfigurationEnhancer>>();

    @Override
    public <C> ComponentRegistry registerComponent(@Nonnull ComponentDefinition<? extends C> definition) {
        Objects.requireNonNull(definition, "The ComponentDefinition must not be null.");
        if (!(definition instanceof ComponentDefinition.ComponentCreator)) {
            throw new IllegalArgumentException("Unsupported component definition type: " + String.valueOf(definition));
        }
        ComponentDefinition.ComponentCreator creator = (ComponentDefinition.ComponentCreator)definition;
        Component component = creator.createComponent();
        Component.Identifier id = component.identifier();
        logger.debug("Registering component [{}] of type [{}].", (Object)id.name(), id.type());
        if (this.overridePolicy == OverridePolicy.REJECT && this.hasComponent(id.type(), id.name())) {
            throw new ComponentOverrideException(id.type(), id.name());
        }
        Component previous = this.components.put(component);
        if (previous != null && this.overridePolicy == OverridePolicy.WARN) {
            logger.warn("Replaced a previous Component registered for type [{}] and name [{}].", (Object)id.name(), id.type());
        }
        return this;
    }

    @Override
    public <C> ComponentRegistry registerDecorator(@Nonnull DecoratorDefinition<C, ? extends C> decorator) {
        Objects.requireNonNull(decorator, "The decorator definition must not be null.");
        if (!(decorator instanceof DecoratorDefinition.CompletedDecoratorDefinition)) {
            throw new IllegalArgumentException("Unsupported decorator definition type: " + String.valueOf(decorator));
        }
        DecoratorDefinition.CompletedDecoratorDefinition decoratorRegistration = (DecoratorDefinition.CompletedDecoratorDefinition)decorator;
        logger.debug("Registering decorator definition: [{}]", decorator);
        this.decoratorDefinitions.add(decoratorRegistration);
        return this;
    }

    @Override
    public boolean hasComponent(@Nonnull Class<?> type, @Nonnull String name) {
        return this.components.contains(new Component.Identifier(type, name));
    }

    @Override
    public ComponentRegistry registerEnhancer(@Nonnull ConfigurationEnhancer enhancer) {
        logger.debug("Registering enhancer [{}].", (Object)enhancer.getClass().getSimpleName());
        this.enhancers.add(enhancer);
        return this;
    }

    @Override
    public ComponentRegistry registerModule(@Nonnull Module module) {
        if (logger.isDebugEnabled()) {
            logger.debug("Registering module [{}].", (Object)module.name());
        }
        if (this.modules.containsKey(module.name())) {
            throw new DuplicateModuleRegistrationException(module);
        }
        this.modules.put(module.name(), module);
        return this;
    }

    public Configuration build(@Nonnull LifecycleRegistry lifecycleRegistry) {
        return this.doBuild(null, lifecycleRegistry);
    }

    public Configuration buildNested(@Nonnull Configuration parent, @Nonnull LifecycleRegistry lifecycleRegistry) {
        return this.doBuild(Objects.requireNonNull(parent), Objects.requireNonNull(lifecycleRegistry));
    }

    private Configuration doBuild(@Nullable Configuration optionalParent, @Nonnull LifecycleRegistry lifecycleRegistry) {
        if (this.initialized.getAndSet(true)) {
            throw new IllegalStateException("Component registry has already been initialized.");
        }
        if (this.enhancerScanning) {
            this.scanForConfigurationEnhancers();
        }
        this.invokeEnhancers();
        this.decorateComponents();
        LocalConfiguration config = new LocalConfiguration(optionalParent);
        this.buildModules(config, lifecycleRegistry);
        this.initializeComponents(config, lifecycleRegistry);
        return config;
    }

    private void decorateComponents() {
        this.decoratorDefinitions.sort(Comparator.comparingInt(DecoratorDefinition.CompletedDecoratorDefinition::order));
        for (DecoratorDefinition.CompletedDecoratorDefinition<?, ?> decorator : this.decoratorDefinitions) {
            for (Component.Identifier<?> id : this.components.identifiers()) {
                if (!decorator.matches(id)) continue;
                this.components.replace(id, decorator::decorate);
            }
        }
    }

    private void invokeEnhancers() {
        this.enhancers.stream().sorted(Comparator.comparingInt(ConfigurationEnhancer::order)).forEach(enhancer -> enhancer.enhance(this));
    }

    private void buildModules(Configuration config, LifecycleRegistry lifecycleRegistry) {
        for (Module module : this.modules.values()) {
            Configuration builtModule = HierarchicalConfiguration.build(lifecycleRegistry, childLifecycleRegistry -> module.build(config, (LifecycleRegistry)childLifecycleRegistry));
            this.moduleConfigurations.put(module.name(), builtModule);
        }
    }

    private void initializeComponents(Configuration config, LifecycleRegistry lifecycleRegistry) {
        this.components.postProcessComponents(c -> c.initLifecycle(config, lifecycleRegistry));
    }

    @Override
    public DefaultComponentRegistry setOverridePolicy(@Nonnull OverridePolicy overridePolicy) {
        this.overridePolicy = Objects.requireNonNull(overridePolicy, "The override policy must not be null.");
        return this;
    }

    @Override
    public DefaultComponentRegistry disableEnhancer(Class<? extends ConfigurationEnhancer> enhancerClass) {
        this.disabledEnhancers.add(enhancerClass);
        return this;
    }

    @Override
    public DefaultComponentRegistry disableEnhancerScanning() {
        this.enhancerScanning = false;
        return this;
    }

    private void scanForConfigurationEnhancers() {
        ServiceLoader<ConfigurationEnhancer> enhancerLoader = ServiceLoader.load(ConfigurationEnhancer.class, this.getClass().getClassLoader());
        enhancerLoader.stream().map(ServiceLoader.Provider::get).filter(enhancer -> !this.disabledEnhancers.contains(enhancer.getClass())).forEach(this::registerEnhancer);
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("initialized", this.initialized.get());
        descriptor.describeProperty("components", this.components);
        descriptor.describeProperty("decorators", this.decoratorDefinitions);
        descriptor.describeProperty("configurerEnhancers", this.enhancers);
        descriptor.describeProperty("modules", this.modules.values());
    }

    private class LocalConfiguration
    implements Configuration {
        private final Configuration parent;

        public LocalConfiguration(Configuration parent) {
            this.parent = parent;
        }

        @Override
        public Configuration getParent() {
            return this.parent;
        }

        @Override
        @Nonnull
        public <C> Optional<C> getOptionalComponent(@Nonnull Class<C> type, @Nonnull String name) {
            return DefaultComponentRegistry.this.components.get(new Component.Identifier<C>(type, name)).map(c -> c.resolve(this)).or(() -> Optional.ofNullable(this.fromParent(type, name, () -> null)));
        }

        @Override
        @Nonnull
        public <C> C getComponent(@Nonnull Class<C> type, @Nonnull String name, @Nonnull Supplier<C> defaultImpl) {
            Component.Identifier identifier = new Component.Identifier(type, name);
            C component = DefaultComponentRegistry.this.components.computeIfAbsent(identifier, () -> new LazyInitializedComponentDefinition(identifier, arg_0 -> this.lambda$getComponent$3(type, name, (Supplier)defaultImpl, arg_0))).resolve(this);
            return type.cast(component);
        }

        private <C> C fromParent(Class<C> type, String name, Supplier<C> defaultSupplier) {
            return this.parent != null ? this.parent.getOptionalComponent(type, name).orElseGet(defaultSupplier) : defaultSupplier.get();
        }

        @Override
        public List<Configuration> getModuleConfigurations() {
            return List.copyOf(DefaultComponentRegistry.this.moduleConfigurations.values());
        }

        @Override
        public void describeTo(@Nonnull ComponentDescriptor descriptor) {
            descriptor.describeProperty("components", DefaultComponentRegistry.this.components);
            descriptor.describeProperty("modules", DefaultComponentRegistry.this.moduleConfigurations.values());
        }

        @Override
        public Optional<Configuration> getModuleConfiguration(@Nonnull String name) {
            Assert.nonEmpty(name, "The name must not be null.");
            return Optional.ofNullable(DefaultComponentRegistry.this.moduleConfigurations.get(name));
        }

        private /* synthetic */ Object lambda$getComponent$3(Class type, String name, Supplier defaultImpl, Configuration c) {
            return this.fromParent(type, name, defaultImpl);
        }
    }
}

