/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.axonframework.common.Assert;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.LifecycleRegistry;

public interface Component<C>
extends DescribableComponent {
    public Identifier<C> identifier();

    public C resolve(@Nonnull Configuration var1);

    public boolean isInstantiated();

    public void initLifecycle(@Nonnull Configuration var1, @Nonnull LifecycleRegistry var2);

    public boolean isInitialized();

    public record Identifier<C>(@Nonnull Class<C> type, @Nonnull String name) {
        public Identifier {
            Objects.requireNonNull(type, "The given type is unsupported because it is null.");
            Assert.nonEmpty(name, "The given name is unsupported because it is null or empty.");
        }

        @Override
        public String toString() {
            return this.type.getName() + ":" + this.name;
        }
    }
}

