/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.retry;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.retry.RetryScheduler;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class RetryingCommandBus
implements CommandBus {
    private final CommandBus delegate;
    private final RetryScheduler retryScheduler;

    public RetryingCommandBus(@Nonnull CommandBus delegate, @Nonnull RetryScheduler retryScheduler) {
        this.delegate = Objects.requireNonNull(delegate, "The command bus delegate must be null.");
        this.retryScheduler = Objects.requireNonNull(retryScheduler, "the RetryScheduler must not be null.");
    }

    @Override
    public RetryingCommandBus subscribe(@Nonnull QualifiedName name, @Nonnull CommandHandler handler) {
        this.delegate.subscribe(name, handler);
        return this;
    }

    @Override
    public CompletableFuture<? extends Message<?>> dispatch(@Nonnull CommandMessage<?> command, @Nullable ProcessingContext processingContext) {
        return this.dispatchToDelegate(command, processingContext).exceptionallyCompose(e -> this.performRetry(command, processingContext, FutureUtils.unwrap(e)));
    }

    private CompletableFuture<Message<?>> dispatchToDelegate(CommandMessage<?> command, ProcessingContext processingContext) {
        return this.delegate.dispatch(command, processingContext).thenApply(Function.identity());
    }

    private CompletableFuture<Message<?>> performRetry(CommandMessage<?> command, ProcessingContext processingContext, Throwable e) {
        return this.retryScheduler.scheduleRetry(command, processingContext, e, this::redispatch).first().asCompletableFuture().thenApply(MessageStream.Entry::message);
    }

    private MessageStream<Message<?>> redispatch(CommandMessage<?> cmd, ProcessingContext ctx) {
        return MessageStream.fromFuture(this.dispatchToDelegate(cmd, ctx));
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf(this.delegate);
        descriptor.describeProperty("retryScheduler", this.retryScheduler);
    }
}

