/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.CommandResult;
import org.axonframework.commandhandling.gateway.FutureCommandResult;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class DefaultCommandGateway
implements CommandGateway {
    private final CommandBus commandBus;
    private final MessageTypeResolver messageTypeResolver;

    public DefaultCommandGateway(@Nonnull CommandBus commandBus, @Nonnull MessageTypeResolver messageTypeResolver) {
        this.commandBus = commandBus;
        this.messageTypeResolver = messageTypeResolver;
    }

    @Override
    public CommandResult send(@Nonnull Object command, @Nullable ProcessingContext context) {
        return new FutureCommandResult((CompletableFuture<? extends Message<?>>)this.commandBus.dispatch(this.asCommandMessage(command, MetaData.emptyInstance()), context).thenCompose(msg -> {
            ResultMessage resultMessage;
            return msg instanceof ResultMessage && (resultMessage = (ResultMessage)msg).isExceptional() ? CompletableFuture.failedFuture(resultMessage.exceptionResult()) : CompletableFuture.completedFuture(msg);
        }));
    }

    @Override
    public CommandResult send(@Nonnull Object command, @Nonnull MetaData metaData, @Nullable ProcessingContext context) {
        return new FutureCommandResult((CompletableFuture<? extends Message<?>>)this.commandBus.dispatch(this.asCommandMessage(command, metaData), context).thenCompose(msg -> {
            ResultMessage resultMessage;
            return msg instanceof ResultMessage && (resultMessage = (ResultMessage)msg).isExceptional() ? CompletableFuture.failedFuture(resultMessage.exceptionResult()) : CompletableFuture.completedFuture(msg);
        }));
    }

    private <C> CommandMessage<C> asCommandMessage(Object command, MetaData metaData) {
        if (command instanceof CommandMessage) {
            return (CommandMessage)command;
        }
        if (command instanceof Message) {
            Message message = (Message)command;
            return new GenericCommandMessage(message.type(), message.getPayload(), message.getMetaData());
        }
        return new GenericCommandMessage<Object>(this.messageTypeResolver.resolve(command), command, metaData);
    }
}

