/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.distributed.Connector;
import org.axonframework.commandhandling.distributed.RoutingStrategy;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class RoutingKeyResolvingConnector
implements Connector {
    private final Connector delegate;
    private final RoutingStrategy routingStrategy;

    public RoutingKeyResolvingConnector(Connector delegate, RoutingStrategy routingStrategy) {
        this.delegate = delegate;
        this.routingStrategy = routingStrategy;
    }

    @Override
    public CompletableFuture<? extends Message<?>> dispatch(CommandMessage<?> command, ProcessingContext processingContext) {
        String routingKey = this.routingStrategy.getRoutingKey(command);
        if (routingKey == null) {
            return this.delegate.dispatch(command, processingContext);
        }
        return this.delegate.dispatch(command, (ProcessingContext)processingContext.withResource((Context.ResourceKey)RoutingStrategy.ROUTING_KEY, routingKey));
    }

    @Override
    public void subscribe(String commandName, int loadFactor) {
        this.delegate.subscribe(commandName, loadFactor);
    }

    @Override
    public boolean unsubscribe(String commandName) {
        return this.delegate.unsubscribe(commandName);
    }

    @Override
    public void onIncomingCommand(BiConsumer<CommandMessage<?>, Connector.ResultCallback> handler) {
        this.delegate.onIncomingCommand(handler);
    }
}

