/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.distributed.Connector;
import org.axonframework.commandhandling.distributed.PriorityResolver;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class PriorityResolvingConnector
implements Connector {
    private final Connector delegate;
    private final PriorityResolver<? super CommandMessage<?>> priorityResolver;

    public PriorityResolvingConnector(Connector delegate, PriorityResolver<? super CommandMessage<?>> priorityResolver) {
        this.delegate = delegate;
        this.priorityResolver = priorityResolver;
    }

    @Override
    public CompletableFuture<? extends Message<?>> dispatch(CommandMessage<?> command, ProcessingContext processingContext) {
        this.priorityResolver.priorityFor(command);
        return this.delegate.dispatch(command, processingContext);
    }

    @Override
    public void subscribe(String commandName, int loadFactor) {
        this.delegate.subscribe(commandName, loadFactor);
    }

    @Override
    public boolean unsubscribe(String commandName) {
        return this.delegate.unsubscribe(commandName);
    }

    @Override
    public void onIncomingCommand(BiConsumer<CommandMessage<?>, Connector.ResultCallback> handler) {
        this.delegate.onIncomingCommand(handler);
    }
}

