/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.annotation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;
import org.axonframework.commandhandling.CommandHandlingComponent;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.SimpleCommandHandlingComponent;
import org.axonframework.commandhandling.annotation.CommandMessageHandlingMember;
import org.axonframework.common.ObjectUtils;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlerInterceptorMemberChain;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class AnnotatedCommandHandlingComponent<T>
implements CommandHandlingComponent {
    private final T target;
    private final AnnotatedHandlerInspector<T> model;
    private final MessageTypeResolver messageTypeResolver;
    private final SimpleCommandHandlingComponent handlingComponent;

    public AnnotatedCommandHandlingComponent(@Nonnull T annotatedCommandHandler) {
        this(annotatedCommandHandler, ClasspathParameterResolverFactory.forClass(annotatedCommandHandler.getClass()));
    }

    public AnnotatedCommandHandlingComponent(@Nonnull T annotatedCommandHandler, @Nonnull ParameterResolverFactory parameterResolverFactory) {
        this(annotatedCommandHandler, parameterResolverFactory, ClasspathHandlerDefinition.forClass(annotatedCommandHandler.getClass()), new ClassBasedMessageTypeResolver());
    }

    public AnnotatedCommandHandlingComponent(@Nonnull T annotatedCommandHandler, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull HandlerDefinition handlerDefinition, @Nonnull MessageTypeResolver messageTypeResolver) {
        this.handlingComponent = SimpleCommandHandlingComponent.create("AnnotationCommandHandlerAdapter[%s]".formatted(annotatedCommandHandler.getClass().getName()));
        this.target = Objects.requireNonNull(annotatedCommandHandler, "The Annotated Command Handler may not be null.");
        this.model = AnnotatedHandlerInspector.inspectType(annotatedCommandHandler.getClass(), parameterResolverFactory, handlerDefinition);
        this.messageTypeResolver = Objects.requireNonNull(messageTypeResolver, "The MessageTypeResolver may not be null.");
        this.initializeHandlersBasedOnModel();
    }

    private void initializeHandlersBasedOnModel() {
        this.model.getAllHandlers().forEach((modelClass, handlers) -> handlers.stream().filter(h -> h.canHandleMessageType(CommandMessage.class)).forEach(this::registerHandler));
    }

    private void registerHandler(MessageHandlingMember<? super T> handler) {
        QualifiedName qualifiedName = handler.unwrap(CommandMessageHandlingMember.class).map(CommandMessageHandlingMember::commandName).map(QualifiedName::new).orElseGet(() -> new QualifiedName(handler.payloadType()));
        MessageHandlerInterceptorMemberChain<T> interceptorChain = this.model.chainedInterceptor(this.target.getClass());
        this.handlingComponent.subscribe(qualifiedName, (command, ctx) -> interceptorChain.handle(command, ctx, this.target, handler).mapMessage(this::asCommandResultMessage).first().cast());
    }

    @Override
    @Nonnull
    public MessageStream.Single<? extends CommandResultMessage<?>> handle(@Nonnull CommandMessage<?> command, @Nonnull ProcessingContext processingContext) {
        return this.handlingComponent.handle(command, processingContext);
    }

    private <R> CommandResultMessage<R> asCommandResultMessage(@Nullable Object commandResult) {
        if (commandResult instanceof CommandResultMessage) {
            return (CommandResultMessage)commandResult;
        }
        if (commandResult instanceof Message) {
            Message commandResultMessage = (Message)commandResult;
            return new GenericCommandResultMessage(commandResultMessage);
        }
        MessageType type = this.messageTypeResolver.resolve(ObjectUtils.nullSafeTypeOf(commandResult));
        return new GenericCommandResultMessage<Object>(type, commandResult);
    }

    @Override
    public Set<QualifiedName> supportedCommands() {
        return Set.copyOf(this.handlingComponent.supportedCommands());
    }
}

