/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import javax.annotation.Nonnull;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventMessageHandler;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingErrorHandler
implements ListenerInvocationErrorHandler {
    private final Logger logger;

    public LoggingErrorHandler() {
        this(LoggerFactory.getLogger(LoggingErrorHandler.class));
    }

    public LoggingErrorHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void onError(@Nonnull Exception exception, @Nonnull EventMessage<?> event, @Nonnull EventMessageHandler eventHandler) {
        this.logger.error("EventListener [{}] failed to handle event [{}] ({}). Continuing processing with next listener", new Object[]{eventHandler.getTargetType().getSimpleName(), event.getIdentifier(), event.getPayloadType().getName(), exception});
    }
}

