/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.jpa;

import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import java.util.Arrays;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Lob;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.SimpleSerializedObject;

@Embeddable
@javax.persistence.Embeddable
public class DeadLetterEventEntry {
    @jakarta.persistence.Basic(optional=false)
    @Basic(optional=false)
    private String messageType;
    @Column(nullable=false)
    @Basic(optional=false)
    private String eventIdentifier;
    @jakarta.persistence.Basic(optional=false)
    @Basic(optional=false)
    private String timeStamp;
    @jakarta.persistence.Basic(optional=false)
    @Basic(optional=false)
    private String payloadType;
    @jakarta.persistence.Basic
    @Basic
    private String payloadRevision;
    @jakarta.persistence.Basic(optional=false)
    @jakarta.persistence.Lob
    @Column(length=10000)
    @Basic(optional=false)
    @Lob
    @javax.persistence.Column(length=10000)
    private byte[] payload;
    @jakarta.persistence.Basic
    @jakarta.persistence.Lob
    @Column(length=10000)
    @Basic
    @Lob
    @javax.persistence.Column(length=10000)
    private byte[] metaData;
    @jakarta.persistence.Basic
    @Basic
    private String type;
    @jakarta.persistence.Basic
    @Basic
    private String aggregateIdentifier;
    @jakarta.persistence.Basic
    @Basic
    private Long sequenceNumber;
    @jakarta.persistence.Basic
    @Basic
    private String tokenType;
    @jakarta.persistence.Basic
    @jakarta.persistence.Lob
    @Column(length=10000)
    @Basic
    @Lob
    @javax.persistence.Column(length=10000)
    private byte[] token;

    protected DeadLetterEventEntry() {
    }

    public DeadLetterEventEntry(String messageType, String messageIdentifier, String messageTimestamp, String payloadType, String payloadRevision, byte[] payload, byte[] metaData, String aggregateType, String aggregateIdentifier, Long sequenceNumber, String tokenType, byte[] token) {
        Objects.requireNonNull(messageType, "Message type should be provided by the DeadLetterJpaConverter, otherwise it can never be converted back.");
        Objects.requireNonNull(messageIdentifier, "All EventMessage implementations require a message identifier.");
        Objects.requireNonNull(messageTimestamp, "All EventMessage implementations require a timestamp.");
        this.messageType = messageType;
        this.eventIdentifier = messageIdentifier;
        this.timeStamp = messageTimestamp;
        this.payloadType = payloadType;
        this.payloadRevision = payloadRevision;
        this.payload = payload;
        this.metaData = metaData;
        this.type = aggregateType;
        this.aggregateIdentifier = aggregateIdentifier;
        this.sequenceNumber = sequenceNumber;
        this.tokenType = tokenType;
        this.token = token;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String getEventIdentifier() {
        return this.eventIdentifier;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public SimpleSerializedObject<byte[]> getPayload() {
        return new SimpleSerializedObject<byte[]>(this.payload, byte[].class, this.payloadType, this.payloadRevision);
    }

    public SimpleSerializedObject<byte[]> getMetaData() {
        return new SimpleSerializedObject<byte[]>(this.metaData, byte[].class, MetaData.class.getName(), null);
    }

    public String getType() {
        return this.type;
    }

    public String getAggregateIdentifier() {
        return this.aggregateIdentifier;
    }

    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public SimpleSerializedObject<byte[]> getTrackingToken() {
        if (this.token == null) {
            return null;
        }
        return new SimpleSerializedObject<byte[]>(this.token, byte[].class, this.tokenType, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeadLetterEventEntry that = (DeadLetterEventEntry)o;
        if (!this.messageType.equals(that.messageType)) {
            return false;
        }
        if (!Objects.equals(this.eventIdentifier, that.eventIdentifier)) {
            return false;
        }
        if (!Objects.equals(this.timeStamp, that.timeStamp)) {
            return false;
        }
        if (!Objects.equals(this.payloadType, that.payloadType)) {
            return false;
        }
        if (!Objects.equals(this.payloadRevision, that.payloadRevision)) {
            return false;
        }
        if (!Arrays.equals(this.payload, that.payload)) {
            return false;
        }
        if (!Arrays.equals(this.metaData, that.metaData)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.aggregateIdentifier, that.aggregateIdentifier)) {
            return false;
        }
        if (!Objects.equals(this.sequenceNumber, that.sequenceNumber)) {
            return false;
        }
        if (!Objects.equals(this.tokenType, that.tokenType)) {
            return false;
        }
        return Arrays.equals(this.token, that.token);
    }

    public int hashCode() {
        int result = this.messageType.hashCode();
        result = 31 * result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
        result = 31 * result + (this.timeStamp != null ? this.timeStamp.hashCode() : 0);
        result = 31 * result + (this.payloadType != null ? this.payloadType.hashCode() : 0);
        result = 31 * result + (this.payloadRevision != null ? this.payloadRevision.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.payload);
        result = 31 * result + Arrays.hashCode(this.metaData);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.aggregateIdentifier != null ? this.aggregateIdentifier.hashCode() : 0);
        result = 31 * result + (this.sequenceNumber != null ? this.sequenceNumber.hashCode() : 0);
        result = 31 * result + (this.tokenType != null ? this.tokenType.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.token);
        return result;
    }

    public String toString() {
        return "DeadLetterEventEntry{messageType='" + this.messageType + '\'' + ", eventIdentifier='" + this.eventIdentifier + '\'' + ", timeStamp='" + this.timeStamp + '\'' + ", payloadType='" + this.payloadType + '\'' + ", payloadRevision='" + this.payloadRevision + '\'' + ", payload=" + Arrays.toString(this.payload) + ", metaData=" + Arrays.toString(this.metaData) + ", type='" + this.type + '\'' + ", aggregateIdentifier='" + this.aggregateIdentifier + '\'' + ", sequenceNumber=" + this.sequenceNumber + ", tokenType='" + this.tokenType + '\'' + ", token=" + Arrays.toString(this.token) + '}';
    }
}

