/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.InterceptorChainParameterResolverFactory;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.MessageInterceptingMember;
import org.axonframework.messaging.annotation.ResultParameterResolverFactory;
import org.axonframework.messaging.annotation.WrappedMessageHandlingMember;
import org.axonframework.messaging.interceptors.MessageHandlerInterceptor;
import org.axonframework.messaging.interceptors.ResultHandler;

public class MessageHandlerInterceptorDefinition
implements HandlerEnhancerDefinition {
    @Override
    @Nonnull
    public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
        if (original.annotationAttributes(MessageHandlerInterceptor.class).isPresent()) {
            Optional<Map<String, Object>> attributes = original.annotationAttributes(ResultHandler.class);
            if (attributes.isPresent()) {
                return new ResultHandlingInterceptorMember<T>(original, (Class)attributes.get().get("resultType"));
            }
            return new InterceptedMessageHandlingMember<T>(original);
        }
        return original;
    }

    private static class InterceptedMessageHandlingMember<T>
    extends WrappedMessageHandlingMember<T>
    implements MessageInterceptingMember<T> {
        private final boolean shouldInvokeInterceptorChain;

        public InterceptedMessageHandlingMember(MessageHandlingMember<T> original) {
            super(original);
            Method method = original.unwrap(Method.class).orElseThrow(() -> new AxonConfigurationException("Only methods can be marked as MessageHandlerInterceptor. Violating handler: " + original.signature()));
            this.shouldInvokeInterceptorChain = Arrays.stream(method.getParameters()).noneMatch(p -> p.getType().equals(InterceptorChain.class));
            if (this.shouldInvokeInterceptorChain && !Void.TYPE.equals(method.getReturnType())) {
                throw new AxonConfigurationException("A MessageHandlerInterceptor must either return null or declare a parameter of type InterceptorChain. Violating handler: " + original.signature());
            }
        }

        @Override
        public Object handle(@Nonnull Message<?> message, @Nullable T target) throws Exception {
            Object result = super.handle(message, target);
            if (this.shouldInvokeInterceptorChain) {
                return InterceptorChainParameterResolverFactory.currentInterceptorChain().proceed();
            }
            return result;
        }
    }

    private static class ResultHandlingInterceptorMember<T>
    extends WrappedMessageHandlingMember<T>
    implements MessageInterceptingMember<T> {
        private final Class<?> expectedResultType;

        public ResultHandlingInterceptorMember(MessageHandlingMember<T> original, Class<?> expectedResultType) {
            super(original);
            this.expectedResultType = expectedResultType;
            Method method = original.unwrap(Method.class).orElseThrow(() -> new AxonConfigurationException("Only methods can be marked as MessageHandlerInterceptor. Violating handler: " + original.signature()));
            boolean declaredInterceptorChain = Arrays.stream(method.getParameters()).anyMatch(p -> p.getType().equals(InterceptorChain.class));
            if (declaredInterceptorChain) {
                throw new AxonConfigurationException("A MessageHandlerInterceptor acting on the invocation result must not declare a parameter of type InterceptorChain. Violating handler: " + original.signature());
            }
        }

        @Override
        public int priority() {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean canHandle(@Nonnull Message<?> message) {
            return ResultParameterResolverFactory.ignoringResultParameters(() -> super.canHandle(message));
        }

        @Override
        public Object handle(@Nonnull Message<?> message, @Nullable T target) throws Exception {
            InterceptorChain chain = InterceptorChainParameterResolverFactory.currentInterceptorChain();
            try {
                return chain.proceed();
            }
            catch (Exception e) {
                if (!this.expectedResultType.isInstance(e)) {
                    throw e;
                }
                return ResultParameterResolverFactory.callWithResult(e, () -> {
                    if (super.canHandle(message)) {
                        return super.handle(message, target);
                    }
                    throw e;
                });
            }
        }
    }
}

