/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter;

import java.lang.invoke.MethodHandles;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.PropagatingErrorHandler;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.SimpleEventHandlerInvoker;
import org.axonframework.eventhandling.deadletter.DeadLetteredEventProcessingTask;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.Decisions;
import org.axonframework.messaging.deadletter.EnqueueDecision;
import org.axonframework.messaging.deadletter.EnqueuePolicy;
import org.axonframework.messaging.deadletter.GenericDeadLetter;
import org.axonframework.messaging.deadletter.SequencedDeadLetterProcessor;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadLetteringEventHandlerInvoker
extends SimpleEventHandlerInvoker
implements SequencedDeadLetterProcessor<EventMessage<?>> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SequencedDeadLetterQueue<EventMessage<?>> queue;
    private final EnqueuePolicy<EventMessage<?>> enqueuePolicy;
    private final TransactionManager transactionManager;
    private final boolean allowReset;

    protected DeadLetteringEventHandlerInvoker(Builder builder) {
        super(builder);
        this.queue = builder.queue;
        this.enqueuePolicy = builder.enqueuePolicy;
        this.transactionManager = builder.transactionManager;
        this.allowReset = builder.allowReset;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void handle(@Nonnull EventMessage<?> message, @Nonnull Segment segment) throws Exception {
        block8: {
            if (!super.sequencingPolicyMatchesSegment(message, segment)) {
                logger.trace("Ignoring event with id [{}] as it is not assigned to segment [{}].", (Object)message.getIdentifier(), (Object)segment);
                return;
            }
            Object sequenceIdentifier = super.sequenceIdentifier(message);
            if (this.queue.enqueueIfPresent(sequenceIdentifier, () -> new GenericDeadLetter<EventMessage>(sequenceIdentifier, message))) {
                if (logger.isInfoEnabled()) {
                    logger.info("Event with id [{}] is added to the dead-letter queue since its queue id [{}] is already present.", (Object)message.getIdentifier(), sequenceIdentifier);
                }
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("Event [{}] with queue id [{}] is not present in the dead-letter queue.Handle operation is delegated to the wrapped EventHandlerInvoker.", message, sequenceIdentifier);
                }
                try {
                    super.invokeHandlers(message);
                }
                catch (Exception e) {
                    GenericDeadLetter letter = new GenericDeadLetter(sequenceIdentifier, message, e);
                    EnqueueDecision<EventMessage<?>> decision = this.enqueuePolicy.decide(letter, e);
                    if (decision.shouldEnqueue()) {
                        Throwable cause = decision.enqueueCause().orElse(null);
                        this.queue.enqueue(sequenceIdentifier, decision.withDiagnostics(letter.withCause(cause)));
                    }
                    if (!logger.isInfoEnabled()) break block8;
                    logger.info("The enqueue policy decided not to dead letter event [{}].", (Object)message.getIdentifier());
                }
            }
        }
    }

    @Override
    public void performReset() {
        if (this.allowReset) {
            this.transactionManager.executeInTransaction(this.queue::clear);
        }
        super.performReset(null);
    }

    @Override
    public <R> void performReset(R resetContext) {
        if (this.allowReset) {
            this.transactionManager.executeInTransaction(this.queue::clear);
        }
        super.performReset(resetContext);
    }

    @Override
    public boolean process(Predicate<DeadLetter<? extends EventMessage<?>>> sequenceFilter) {
        DeadLetteredEventProcessingTask processingTask = new DeadLetteredEventProcessingTask(super.eventHandlers(), this.enqueuePolicy, this.transactionManager);
        DefaultUnitOfWork<Object> uow = new DefaultUnitOfWork<Object>(null);
        uow.attachTransaction(this.transactionManager);
        return (Boolean)uow.executeWithResult(() -> this.queue.process(sequenceFilter, processingTask::process)).getPayload();
    }

    public static class Builder
    extends SimpleEventHandlerInvoker.Builder<Builder> {
        private SequencedDeadLetterQueue<EventMessage<?>> queue;
        private EnqueuePolicy<EventMessage<?>> enqueuePolicy = (letter, cause) -> Decisions.enqueue(cause);
        private TransactionManager transactionManager;
        private boolean allowReset = false;

        private Builder() {
            super.listenerInvocationErrorHandler(PropagatingErrorHandler.instance());
        }

        public Builder queue(@Nonnull SequencedDeadLetterQueue<EventMessage<?>> queue) {
            BuilderUtils.assertNonNull(queue, "The DeadLetterQueue may not be null");
            this.queue = queue;
            return this;
        }

        public Builder enqueuePolicy(EnqueuePolicy<EventMessage<?>> enqueuePolicy) {
            BuilderUtils.assertNonNull(enqueuePolicy, "The EnqueuePolicy should be non null");
            this.enqueuePolicy = enqueuePolicy;
            return this;
        }

        public Builder transactionManager(@Nonnull TransactionManager transactionManager) {
            BuilderUtils.assertNonNull(transactionManager, "The TransactionManager may not be null");
            this.transactionManager = transactionManager;
            return this;
        }

        public Builder allowReset(boolean allowReset) {
            this.allowReset = allowReset;
            return this;
        }

        @Override
        public DeadLetteringEventHandlerInvoker build() {
            return new DeadLetteringEventHandlerInvoker(this);
        }

        @Override
        protected void validate() {
            BuilderUtils.assertNonNull(this.queue, "The DeadLetterQueue is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.transactionManager, "The TransactionManager is a hard requirement and should be provided");
        }
    }
}

