/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.jobrunr;

import java.io.Serializable;
import java.time.Instant;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.deadline.AbstractDeadlineManager;
import org.axonframework.deadline.DeadlineException;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.deadline.jobrunr.DeadlineDetails;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.ExecutionException;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.messaging.ScopeAwareProvider;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.tracing.NoOpSpanFactory;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanFactory;
import org.jobrunr.jobs.lambdas.IocJobLambda;
import org.jobrunr.scheduling.JobScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRunrDeadlineManager
extends AbstractDeadlineManager {
    private static final Logger logger = LoggerFactory.getLogger(JobRunrDeadlineManager.class);
    private final ScopeAwareProvider scopeAwareProvider;
    private final JobScheduler jobScheduler;
    private final Serializer serializer;
    private final TransactionManager transactionManager;
    private final SpanFactory spanFactory;

    public static Builder builder() {
        return new Builder();
    }

    protected JobRunrDeadlineManager(Builder builder) {
        builder.validate();
        this.scopeAwareProvider = builder.scopeAwareProvider;
        this.jobScheduler = builder.jobScheduler;
        this.serializer = builder.serializer;
        this.transactionManager = builder.transactionManager;
        this.spanFactory = builder.spanFactory;
    }

    @Override
    public String schedule(@Nonnull Instant triggerDateTime, @Nonnull String deadlineName, @Nullable Object messageOrPayload, @Nonnull ScopeDescriptor deadlineScope) {
        DeadlineMessage deadlineMessage = GenericDeadlineMessage.asDeadlineMessage(deadlineName, messageOrPayload, triggerDateTime);
        UUID deadlineId = UUID.randomUUID();
        Span span = this.spanFactory.createDispatchSpan(() -> "JobRunrDeadlineManager.schedule(" + deadlineName + ")", deadlineMessage, new Message[0]);
        this.runOnPrepareCommitOrNow(span.wrapRunnable(() -> {
            DeadlineMessage interceptedDeadlineMessage = this.processDispatchInterceptors(deadlineMessage);
            String deadlineDetails = DeadlineDetails.serialized(deadlineName, deadlineScope, interceptedDeadlineMessage, this.serializer);
            this.jobScheduler.schedule(deadlineId, triggerDateTime, (IocJobLambda & Serializable)deadlineManager -> deadlineManager.execute(deadlineDetails));
        }));
        return deadlineId.toString();
    }

    @Override
    public void cancelSchedule(@Nonnull String deadlineName, @Nonnull String scheduleId) {
        Span span = this.spanFactory.createInternalSpan(() -> "JobRunrDeadlineManager.cancelSchedule(" + deadlineName + "," + scheduleId + ")");
        this.runOnPrepareCommitOrNow(span.wrapRunnable(() -> this.jobScheduler.delete(this.toUuid(scheduleId), "Deleted via DeadlineManager API")));
    }

    @Override
    public void cancelAll(@Nonnull String deadlineName) {
        throw new UnsupportedOperationException("The 'cancelAll' method is not implemented for JobRunrDeadlineManager, use 'cancelSchedule' instead.\nThis requires keeping track of the return value from 'schedule'.");
    }

    private UUID toUuid(@Nonnull String scheduleId) {
        try {
            return UUID.fromString(scheduleId);
        }
        catch (IllegalArgumentException e) {
            throw new DeadlineException("For jobrunr the scheduleId should be an UUID representation.", e);
        }
    }

    @Override
    public void cancelAllWithinScope(@Nonnull String deadlineName, @Nonnull ScopeDescriptor scope) {
        throw new UnsupportedOperationException("The 'cancelAllWithinScope' method is not implemented for JobRunrDeadlineManager, use 'cancelSchedule' instead.\nThis requires keeping track of the return value from 'schedule'.");
    }

    public void execute(@Nonnull String serializedDeadlineDetails) {
        SimpleSerializedObject<String> serializedDeadlineMetaData = new SimpleSerializedObject<String>(serializedDeadlineDetails, String.class, DeadlineDetails.class.getName(), null);
        DeadlineDetails deadlineDetails = (DeadlineDetails)this.serializer.deserialize(serializedDeadlineMetaData);
        GenericDeadlineMessage deadlineMessage = deadlineDetails.asDeadLineMessage(this.serializer);
        Span span = this.spanFactory.createLinkedHandlerSpan(() -> "DeadlineJob.execute", deadlineMessage, new Message[0]).start();
        DefaultUnitOfWork<GenericDeadlineMessage> unitOfWork = new DefaultUnitOfWork<GenericDeadlineMessage>(deadlineMessage);
        unitOfWork.attachTransaction(this.transactionManager);
        unitOfWork.onRollback(uow -> span.recordException(uow.getExecutionResult().getExceptionResult()));
        unitOfWork.onCleanup(uow -> span.end());
        DefaultInterceptorChain<DeadlineMessage> chain = new DefaultInterceptorChain<DeadlineMessage>(unitOfWork, this.handlerInterceptors(), interceptedDeadlineMessage -> {
            this.executeScheduledDeadline((DeadlineMessage<?>)interceptedDeadlineMessage, deadlineDetails.getDeserializedScopeDescriptor(this.serializer));
            return null;
        });
        ResultMessage<Object> resultMessage = unitOfWork.executeWithResult(chain::proceed);
        if (resultMessage.isExceptional()) {
            Throwable e = resultMessage.exceptionResult();
            logger.warn("An error occurred while triggering deadline with name [{}].", (Object)deadlineDetails.getDeadlineName());
            throw new DeadlineException("Failed to process", e);
        }
    }

    private void executeScheduledDeadline(DeadlineMessage<?> deadlineMessage, ScopeDescriptor deadlineScope) {
        this.scopeAwareProvider.provideScopeAwareStream(deadlineScope).filter(scopeAwareComponent -> scopeAwareComponent.canResolve(deadlineScope)).forEach(scopeAwareComponent -> {
            try {
                scopeAwareComponent.send(deadlineMessage, deadlineScope);
            }
            catch (Exception e) {
                String exceptionMessage = String.format("Failed to send a DeadlineMessage for scope [%s]", deadlineScope.scopeDescription());
                throw new ExecutionException(exceptionMessage, e);
            }
        });
    }

    @Override
    public void shutdown() {
        this.jobScheduler.shutdown();
    }

    public static class Builder {
        private JobScheduler jobScheduler;
        private ScopeAwareProvider scopeAwareProvider;
        private Serializer serializer;
        private TransactionManager transactionManager = NoTransactionManager.INSTANCE;
        private SpanFactory spanFactory = NoOpSpanFactory.INSTANCE;

        public Builder jobScheduler(JobScheduler jobScheduler) {
            BuilderUtils.assertNonNull(jobScheduler, "JobScheduler may not be null");
            this.jobScheduler = jobScheduler;
            return this;
        }

        public Builder scopeAwareProvider(ScopeAwareProvider scopeAwareProvider) {
            BuilderUtils.assertNonNull(scopeAwareProvider, "ScopeAwareProvider may not be null");
            this.scopeAwareProvider = scopeAwareProvider;
            return this;
        }

        public Builder serializer(Serializer serializer) {
            BuilderUtils.assertNonNull(serializer, "Serializer may not be null");
            this.serializer = serializer;
            return this;
        }

        public Builder transactionManager(TransactionManager transactionManager) {
            BuilderUtils.assertNonNull(transactionManager, "TransactionManager may not be null");
            this.transactionManager = transactionManager;
            return this;
        }

        public Builder spanFactory(@Nonnull SpanFactory spanFactory) {
            BuilderUtils.assertNonNull(spanFactory, "SpanFactory may not be null");
            this.spanFactory = spanFactory;
            return this;
        }

        public JobRunrDeadlineManager build() {
            return new JobRunrDeadlineManager(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.scopeAwareProvider, "The ScopeAwareProvider is a hard requirement and should be provided.");
            BuilderUtils.assertNonNull(this.jobScheduler, "The JobScheduler is a hard requirement and should be provided.");
            BuilderUtils.assertNonNull(this.serializer, "The Serializer is a hard requirement and should be provided.");
        }
    }
}

