/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventMessageHandler;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.Decisions;
import org.axonframework.messaging.deadletter.EnqueueDecision;
import org.axonframework.messaging.deadletter.EnqueuePolicy;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeadLetteredEventProcessingTask
implements Function<DeadLetter<EventMessage<?>>, EnqueueDecision<EventMessage<?>>> {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<EventMessageHandler> eventHandlingComponents;
    private final EnqueuePolicy<EventMessage<?>> enqueuePolicy;
    private final TransactionManager transactionManager;

    DeadLetteredEventProcessingTask(List<EventMessageHandler> eventHandlingComponents, EnqueuePolicy<EventMessage<?>> enqueuePolicy, TransactionManager transactionManager) {
        this.eventHandlingComponents = eventHandlingComponents;
        this.enqueuePolicy = enqueuePolicy;
        this.transactionManager = transactionManager;
    }

    @Override
    public EnqueueDecision<EventMessage<?>> apply(DeadLetter<EventMessage<?>> letter) {
        return this.process(letter);
    }

    public EnqueueDecision<EventMessage<?>> process(DeadLetter<? extends EventMessage<?>> letter) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Start evaluation of dead letter with message id [{}].", (Object)letter.message().getIdentifier());
        }
        AtomicReference decision = new AtomicReference();
        DefaultUnitOfWork<EventMessage<?>> unitOfWork = DefaultUnitOfWork.startAndGet(letter.message());
        unitOfWork.attachTransaction(this.transactionManager);
        unitOfWork.onPrepareCommit(uow -> decision.set(this.onCommit(letter)));
        unitOfWork.onRollback(uow -> decision.set(this.onRollback(letter, uow.getExecutionResult().getExceptionResult())));
        unitOfWork.executeWithResult(() -> this.handle(letter));
        return (EnqueueDecision)((Object)ObjectUtils.getOrDefault(decision.get(), Decisions::ignore));
    }

    private Object handle(DeadLetter<? extends EventMessage<?>> letter) throws Exception {
        for (EventMessageHandler handler : this.eventHandlingComponents) {
            handler.handle(letter.message());
        }
        return null;
    }

    private EnqueueDecision<EventMessage<?>> onCommit(DeadLetter<? extends EventMessage<?>> letter) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Processing dead letter with message id [{}] was successful.", (Object)letter.message().getIdentifier());
        }
        return Decisions.evict();
    }

    private EnqueueDecision<EventMessage<?>> onRollback(DeadLetter<? extends EventMessage<?>> letter, Throwable cause) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Processing dead letter with message id [{}] failed.", (Object)letter.message().getIdentifier(), (Object)cause);
        }
        return this.enqueuePolicy.decide(letter, cause);
    }
}

