/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.jpa;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.common.jpa.PagingJpaQueryIterable;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.deadletter.jpa.DeadLetterEntry;
import org.axonframework.eventhandling.deadletter.jpa.DeadLetterEventEntry;
import org.axonframework.eventhandling.deadletter.jpa.DeadLetterJpaConverter;
import org.axonframework.eventhandling.deadletter.jpa.EventMessageDeadLetterJpaConverter;
import org.axonframework.eventhandling.deadletter.jpa.JpaDeadLetter;
import org.axonframework.eventhandling.deadletter.jpa.NoJpaConverterFoundException;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.deadletter.Cause;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.DeadLetterQueueOverflowException;
import org.axonframework.messaging.deadletter.EnqueueDecision;
import org.axonframework.messaging.deadletter.GenericDeadLetter;
import org.axonframework.messaging.deadletter.NoSuchDeadLetterException;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.axonframework.messaging.deadletter.WrongDeadLetterTypeException;
import org.axonframework.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaSequencedDeadLetterQueue<M extends EventMessage<?>>
implements SequencedDeadLetterQueue<M> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String processingGroup;
    private final EntityManagerProvider entityManagerProvider;
    private final List<DeadLetterJpaConverter<EventMessage<?>>> converters;
    private final TransactionManager transactionManager;
    private final int maxSequences;
    private final int maxSequenceSize;
    private final int queryPageSize;
    private final Serializer serializer;
    private final Duration claimDuration;

    protected <T extends EventMessage<?>> JpaSequencedDeadLetterQueue(Builder<T> builder) {
        builder.validate();
        this.processingGroup = ((Builder)builder).processingGroup;
        this.maxSequences = ((Builder)builder).maxSequences;
        this.maxSequenceSize = ((Builder)builder).maxSequenceSize;
        this.entityManagerProvider = ((Builder)builder).entityManagerProvider;
        this.transactionManager = ((Builder)builder).transactionManager;
        this.serializer = ((Builder)builder).serializer;
        this.converters = ((Builder)builder).converters;
        this.claimDuration = ((Builder)builder).claimDuration;
        this.queryPageSize = ((Builder)builder).queryPageSize;
    }

    public static <M extends EventMessage<?>> Builder<M> builder() {
        return new Builder();
    }

    @Override
    public void enqueue(@Nonnull Object sequenceIdentifier, @Nonnull DeadLetter<? extends M> letter) throws DeadLetterQueueOverflowException {
        String stringSequenceIdentifier = this.toStringSequenceIdentifier(sequenceIdentifier);
        if (this.isFull(stringSequenceIdentifier)) {
            throw new DeadLetterQueueOverflowException("No room left to enqueue [" + letter.message() + "] for identifier [" + stringSequenceIdentifier + "] since the queue is full.");
        }
        Optional<Cause> optionalCause = letter.cause();
        if (optionalCause.isPresent()) {
            logger.info("Adding dead letter with message id [{}] because [{}].", (Object)((EventMessage)letter.message()).getIdentifier(), (Object)optionalCause.get());
        } else {
            logger.info("Adding dead letter with message id [{}] because the sequence identifier [{}] is already present.", (Object)((EventMessage)letter.message()).getIdentifier(), (Object)stringSequenceIdentifier);
        }
        DeadLetterEventEntry entry = this.converters.stream().filter(c -> c.canConvert((EventMessage)letter.message())).findFirst().map(c -> c.convert((EventMessage)letter.message(), this.serializer)).orElseThrow(() -> new NoJpaConverterFoundException(String.format("No converter found for message of type: [%s]", ((EventMessage)letter.message()).getClass().getName())));
        this.transactionManager.executeInTransaction(() -> {
            Long sequenceIndex = this.getNextIndexForSequence(stringSequenceIdentifier);
            DeadLetterEntry deadLetter = new DeadLetterEntry(this.processingGroup, stringSequenceIdentifier, sequenceIndex, entry, letter.enqueuedAt(), letter.lastTouched(), letter.cause().orElse(null), letter.diagnostics(), this.serializer);
            logger.info("Storing DeadLetter (id: [{}]) for sequence [{}] with index [{}] in processing group [{}].", new Object[]{deadLetter.getDeadLetterId(), stringSequenceIdentifier, sequenceIndex, this.processingGroup});
            this.entityManager().persist((Object)deadLetter);
        });
    }

    @Override
    public void evict(DeadLetter<? extends M> letter) {
        if (!(letter instanceof JpaDeadLetter)) {
            throw new WrongDeadLetterTypeException(String.format("Evict should be called with a JpaDeadLetter instance. Instead got: [%s]", letter.getClass().getName()));
        }
        JpaDeadLetter jpaDeadLetter = (JpaDeadLetter)letter;
        logger.info("Evicting JpaDeadLetter with id {} for processing group {} and sequence {}", new Object[]{jpaDeadLetter.getId(), this.processingGroup, jpaDeadLetter.getSequenceIdentifier()});
        this.transactionManager.executeInTransaction(() -> {
            int deletedRows = this.entityManager().createQuery("delete from DeadLetterEntry dl where dl.deadLetterId=:deadLetterId").setParameter("deadLetterId", (Object)jpaDeadLetter.getId()).executeUpdate();
            if (deletedRows == 0) {
                logger.info("JpaDeadLetter with id {} for processing group {} and sequence {} was already evicted", new Object[]{jpaDeadLetter.getId(), this.processingGroup, jpaDeadLetter.getSequenceIdentifier()});
            }
        });
    }

    @Override
    public void requeue(@Nonnull DeadLetter<? extends M> letter, @Nonnull UnaryOperator<DeadLetter<? extends M>> letterUpdater) throws NoSuchDeadLetterException {
        if (!(letter instanceof JpaDeadLetter)) {
            throw new WrongDeadLetterTypeException(String.format("Evict should be called with a JpaDeadLetter instance. Instead got: [%s]", letter.getClass().getName()));
        }
        EntityManager entityManager = this.entityManager();
        DeadLetter updatedLetter = ((DeadLetter)letterUpdater.apply(letter)).markTouched();
        String id = ((JpaDeadLetter)letter).getId();
        DeadLetterEntry letterEntity = (DeadLetterEntry)entityManager.find(DeadLetterEntry.class, (Object)id);
        if (letterEntity == null) {
            throw new NoSuchDeadLetterException(String.format("Can not find dead letter with id [%s] to requeue.", id));
        }
        letterEntity.setDiagnostics(updatedLetter.diagnostics(), this.serializer);
        letterEntity.setLastTouched(updatedLetter.lastTouched());
        letterEntity.setCause(updatedLetter.cause().orElse(null));
        letterEntity.clearProcessingStarted();
        logger.info("Requeueing dead letter with id [{}] with cause [{}]", (Object)letterEntity.getDeadLetterId(), updatedLetter.cause());
        entityManager.persist((Object)letterEntity);
    }

    @Override
    public boolean contains(@Nonnull Object sequenceIdentifier) {
        String stringSequenceIdentifier = this.toStringSequenceIdentifier(sequenceIdentifier);
        return this.sequenceSize(stringSequenceIdentifier) > 0L;
    }

    @Override
    public Iterable<DeadLetter<? extends M>> deadLetterSequence(@Nonnull Object sequenceIdentifier) {
        String stringSequenceIdentifier = this.toStringSequenceIdentifier(sequenceIdentifier);
        return new PagingJpaQueryIterable<DeadLetterEntry, DeadLetter>(this.queryPageSize, this.transactionManager, () -> this.entityManagerProvider.getEntityManager().createQuery("select dl from DeadLetterEntry dl where dl.processingGroup=:processingGroup and dl.sequenceIdentifier=:identifier", DeadLetterEntry.class).setParameter("processingGroup", (Object)this.processingGroup).setParameter("identifier", (Object)stringSequenceIdentifier), this::toLetter);
    }

    @Override
    public Iterable<Iterable<DeadLetter<? extends M>>> deadLetters() {
        List sequenceIdentifiers = this.entityManagerProvider.getEntityManager().createQuery("select dl.sequenceIdentifier from DeadLetterEntry dl where dl.processingGroup=:processingGroup and dl.sequenceIndex = (select min(dl2.sequenceIndex) from DeadLetterEntry dl2 where dl2.processingGroup=dl.processingGroup and dl2.sequenceIdentifier=dl.sequenceIdentifier) order by dl.lastTouched asc ", String.class).setParameter("processingGroup", (Object)this.processingGroup).getResultList();
        return () -> {
            final Iterator sequenceIterator = sequenceIdentifiers.iterator();
            return new Iterator<Iterable<DeadLetter<? extends M>>>(){

                @Override
                public boolean hasNext() {
                    return sequenceIterator.hasNext();
                }

                @Override
                public Iterable<DeadLetter<? extends M>> next() {
                    String next = (String)sequenceIterator.next();
                    return JpaSequencedDeadLetterQueue.this.deadLetterSequence(next);
                }
            };
        };
    }

    private JpaDeadLetter<M> toLetter(DeadLetterEntry entry) {
        DeadLetterJpaConverter converter = this.converters.stream().filter(c -> c.canConvert(entry.getMessage())).findFirst().orElseThrow(() -> new NoJpaConverterFoundException(String.format("No converter found to convert message of class [%s].", entry.getMessage().getMessageType())));
        MetaData deserializedDiagnostics = (MetaData)this.serializer.deserialize(entry.getDiagnostics());
        return new JpaDeadLetter(entry, deserializedDiagnostics, converter.convert(entry.getMessage(), this.serializer));
    }

    @Override
    public boolean isFull(@Nonnull Object sequenceIdentifier) {
        String stringSequenceIdentifier = this.toStringSequenceIdentifier(sequenceIdentifier);
        long numberInSequence = this.sequenceSize(stringSequenceIdentifier);
        if (numberInSequence > 0L) {
            return numberInSequence >= (long)this.maxSequenceSize;
        }
        return this.amountOfSequences() >= (long)this.maxSequences;
    }

    @Override
    public boolean process(@Nonnull Predicate<DeadLetter<? extends M>> sequenceFilter, @Nonnull Function<DeadLetter<? extends M>, EnqueueDecision<M>> processingTask) {
        JpaDeadLetter<M> claimedLetter = null;
        Iterator<JpaDeadLetter<M>> iterator = this.findFirstLetterOfEachAvailableSequence(10);
        while (iterator.hasNext() && claimedLetter == null) {
            JpaDeadLetter<M> next = iterator.next();
            if (!sequenceFilter.test(next) || !this.claimDeadLetter(next)) continue;
            claimedLetter = next;
        }
        if (claimedLetter != null) {
            return this.processLetterAndFollowing(claimedLetter, processingTask);
        }
        logger.info("No claimable and/or matching dead letters found to process.");
        return false;
    }

    @Override
    public boolean process(@Nonnull Function<DeadLetter<? extends M>, EnqueueDecision<M>> processingTask) {
        Iterator<JpaDeadLetter<M>> iterator = this.findFirstLetterOfEachAvailableSequence(1);
        if (iterator.hasNext()) {
            JpaDeadLetter<M> deadLetter = iterator.next();
            this.claimDeadLetter(deadLetter);
            return this.processLetterAndFollowing(deadLetter, processingTask);
        }
        return false;
    }

    private boolean processLetterAndFollowing(JpaDeadLetter<M> firstDeadLetter, Function<DeadLetter<? extends M>, EnqueueDecision<M>> processingTask) {
        JpaDeadLetter<M> deadLetter = firstDeadLetter;
        while (deadLetter != null) {
            logger.info("Processing dead letter with id [{}]", (Object)deadLetter.getId());
            EnqueueDecision decision = processingTask.apply(deadLetter);
            if (!decision.shouldEnqueue()) {
                JpaDeadLetter<M> oldLetter = deadLetter;
                DeadLetterEntry deadLetterEntry = this.findNextDeadLetter(oldLetter);
                if (deadLetterEntry != null) {
                    deadLetter = this.toLetter(deadLetterEntry);
                    this.claimDeadLetter(deadLetter);
                } else {
                    deadLetter = null;
                }
                this.evict(oldLetter);
                continue;
            }
            this.requeue(deadLetter, l -> decision.withDiagnostics((DeadLetter)l).withCause(decision.enqueueCause().orElse(null)));
            return false;
        }
        return true;
    }

    private Iterator<JpaDeadLetter<M>> findFirstLetterOfEachAvailableSequence(int pageSize) {
        return new PagingJpaQueryIterable<DeadLetterEntry, JpaDeadLetter>(pageSize, this.transactionManager, () -> this.entityManager().createQuery("select dl from DeadLetterEntry dl where dl.processingGroup=:processingGroup and dl.sequenceIndex = (select min(dl2.sequenceIndex) from DeadLetterEntry dl2 where dl2.processingGroup=dl.processingGroup and dl2.sequenceIdentifier=dl.sequenceIdentifier) and (dl.processingStarted is null or dl.processingStarted < :processingStartedLimit) order by dl.lastTouched asc ", DeadLetterEntry.class).setParameter("processingGroup", (Object)this.processingGroup).setParameter("processingStartedLimit", (Object)this.getProcessingStartedLimit()), this::toLetter).iterator();
    }

    private DeadLetterEntry findNextDeadLetter(JpaDeadLetter<M> oldLetter) {
        return this.transactionManager.fetchInTransaction(() -> {
            try {
                return (DeadLetterEntry)this.entityManager().createQuery("select dl from DeadLetterEntry dl where dl.processingGroup=:processingGroup and dl.sequenceIdentifier=:sequenceIdentifier and dl.sequenceIndex > :previousIndex order by dl.sequenceIndex asc ", DeadLetterEntry.class).setParameter("processingGroup", (Object)this.processingGroup).setParameter("sequenceIdentifier", (Object)oldLetter.getSequenceIdentifier()).setParameter("previousIndex", (Object)oldLetter.getIndex()).setMaxResults(1).getSingleResult();
            }
            catch (NoResultException exception) {
                return null;
            }
        });
    }

    private boolean claimDeadLetter(JpaDeadLetter<M> deadLetter) {
        Instant processingStartedLimit = this.getProcessingStartedLimit();
        return this.transactionManager.fetchInTransaction(() -> {
            int updatedRows = this.entityManager().createQuery("update DeadLetterEntry dl set dl.processingStarted=:time where dl.deadLetterId=:deadletterId and (dl.processingStarted is null or dl.processingStarted < :processingStartedLimit)").setParameter("deadletterId", (Object)deadLetter.getId()).setParameter("time", (Object)GenericDeadLetter.clock.instant()).setParameter("processingStartedLimit", (Object)processingStartedLimit).executeUpdate();
            if (updatedRows > 0) {
                logger.info("Claimed dead letter with id [{}] to process.", (Object)deadLetter.getId());
                return true;
            }
            logger.info("Failed to claim dead letter with id [{}].", (Object)deadLetter.getId());
            return false;
        });
    }

    private Instant getProcessingStartedLimit() {
        return GenericDeadLetter.clock.instant().minus(this.claimDuration);
    }

    @Override
    public void clear() {
        this.transactionManager.executeInTransaction(() -> this.entityManagerProvider.getEntityManager().createQuery("delete from DeadLetterEntry dl where dl.processingGroup=:processingGroup").setParameter("processingGroup", (Object)this.processingGroup).executeUpdate());
    }

    @Override
    public long sequenceSize(@Nonnull Object sequenceIdentifier) {
        return this.transactionManager.fetchInTransaction(() -> (Long)this.entityManagerProvider.getEntityManager().createQuery("select count(dl) from DeadLetterEntry dl where dl.processingGroup=:processingGroup and dl.sequenceIdentifier=:sequenceIdentifier", Long.class).setParameter("processingGroup", (Object)this.processingGroup).setParameter("sequenceIdentifier", sequenceIdentifier).getSingleResult());
    }

    @Override
    public long size() {
        return this.transactionManager.fetchInTransaction(() -> (Long)this.entityManagerProvider.getEntityManager().createQuery("select count(dl) from DeadLetterEntry dl where dl.processingGroup=:processingGroup", Long.class).setParameter("processingGroup", (Object)this.processingGroup).getSingleResult());
    }

    @Override
    public long amountOfSequences() {
        return this.transactionManager.fetchInTransaction(() -> (Long)this.entityManagerProvider.getEntityManager().createQuery("select count(distinct dl.sequenceIdentifier) from DeadLetterEntry dl where dl.processingGroup=:processingGroup", Long.class).setParameter("processingGroup", (Object)this.processingGroup).getSingleResult());
    }

    private Long getNextIndexForSequence(String sequenceIdentifier) {
        Long maxIndex = this.getMaxIndexForSequence(sequenceIdentifier);
        if (maxIndex == null) {
            return 0L;
        }
        return maxIndex + 1L;
    }

    private Long getMaxIndexForSequence(String sequenceIdentifier) {
        return this.transactionManager.fetchInTransaction(() -> {
            try {
                return (Long)this.entityManager().createQuery("select max(dl.sequenceIndex) from DeadLetterEntry dl where dl.processingGroup=:processingGroup and dl.sequenceIdentifier=:sequenceIdentifier", Long.class).setParameter("sequenceIdentifier", (Object)sequenceIdentifier).setParameter("processingGroup", (Object)this.processingGroup).getSingleResult();
            }
            catch (NoResultException e) {
                return null;
            }
        });
    }

    private String toStringSequenceIdentifier(Object sequenceIdentifier) {
        if (sequenceIdentifier instanceof String) {
            return (String)sequenceIdentifier;
        }
        return Integer.toString(sequenceIdentifier.hashCode());
    }

    private EntityManager entityManager() {
        return this.entityManagerProvider.getEntityManager();
    }

    public static class Builder<T extends EventMessage<?>> {
        private final List<DeadLetterJpaConverter<EventMessage<?>>> converters = new LinkedList();
        private String processingGroup = null;
        private int maxSequences = 1024;
        private int maxSequenceSize = 1024;
        private int queryPageSize = 100;
        private EntityManagerProvider entityManagerProvider;
        private TransactionManager transactionManager;
        private Serializer serializer;
        private Duration claimDuration = Duration.ofSeconds(30L);

        public Builder() {
            this.converters.add(new EventMessageDeadLetterJpaConverter());
        }

        public Builder<T> processingGroup(String processingGroup) {
            BuilderUtils.assertNonEmpty(processingGroup, "Can not set processingGroup to an empty String.");
            this.processingGroup = processingGroup;
            return this;
        }

        public Builder<T> maxSequences(int maxSequences) {
            BuilderUtils.assertStrictPositive(maxSequences, "The maximum number of sequences should be larger or equal to 0");
            this.maxSequences = maxSequences;
            return this;
        }

        public Builder<T> maxSequenceSize(int maxSequenceSize) {
            BuilderUtils.assertStrictPositive(maxSequenceSize, "The maximum number of entries in a sequence should be larger or equal to 128");
            this.maxSequenceSize = maxSequenceSize;
            return this;
        }

        public Builder<T> entityManagerProvider(EntityManagerProvider entityManagerProvider) {
            BuilderUtils.assertNonNull(entityManagerProvider, "EntityManagerProvider may not be null");
            this.entityManagerProvider = entityManagerProvider;
            return this;
        }

        public Builder<T> transactionManager(TransactionManager transactionManager) {
            BuilderUtils.assertNonNull(transactionManager, "TransactionManager may not be null");
            this.transactionManager = transactionManager;
            return this;
        }

        public Builder<T> serializer(Serializer serializer) {
            BuilderUtils.assertNonNull(serializer, "The serializer may not be null");
            this.serializer = serializer;
            return this;
        }

        public Builder<T> clearConverters() {
            this.converters.clear();
            return this;
        }

        public Builder<T> addConverter(DeadLetterJpaConverter<EventMessage<?>> converter) {
            BuilderUtils.assertNonNull(this.claimDuration, "Can not add a null DeadLetterJpaConverter.");
            this.converters.add(converter);
            return this;
        }

        public Builder<T> claimDuration(Duration claimDuration) {
            BuilderUtils.assertNonNull(claimDuration, "Claim duration can not be set to null.");
            this.claimDuration = claimDuration;
            return this;
        }

        public Builder<T> queryPageSize(int queryPageSize) {
            BuilderUtils.assertStrictPositive(queryPageSize, "The query page size must be at least 1.");
            this.queryPageSize = queryPageSize;
            return this;
        }

        public JpaSequencedDeadLetterQueue<T> build() {
            return new JpaSequencedDeadLetterQueue(this);
        }

        protected void validate() {
            BuilderUtils.assertNonEmpty(this.processingGroup, "Must supply processingGroup when constructing a JpaSequencedDeadLetterQueue");
            BuilderUtils.assertNonNull(this.transactionManager, "Must supply a TransactionManager when constructing a JpaSequencedDeadLetterQueue");
            BuilderUtils.assertNonNull(this.entityManagerProvider, "Must supply a EntityManagerProvider when constructing a JpaSequencedDeadLetterQueue");
            BuilderUtils.assertNonNull(this.serializer, "Must supply a Serializer when constructing a JpaSequencedDeadLetterQueue");
        }
    }
}

