/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.responsetypes;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.TypeReflectionUtils;
import org.axonframework.messaging.responsetypes.ResponseType;

public abstract class AbstractResponseType<R>
implements ResponseType<R> {
    protected final Class<?> expectedResponseType;

    protected AbstractResponseType(Class<?> expectedResponseType) {
        this.expectedResponseType = (Class)ReflectionUtils.resolvePrimitiveWrapperTypeIfPrimitive(expectedResponseType);
    }

    @Override
    public Class<?> getExpectedResponseType() {
        return this.expectedResponseType;
    }

    @Deprecated
    protected Type unwrapIfTypeFuture(Type type) {
        return ReflectionUtils.unwrapIfType(type, Future.class);
    }

    protected boolean isIterableOfExpectedType(Type responseType) {
        Type iterableType = TypeReflectionUtils.getExactSuperType(responseType, Iterable.class);
        return iterableType != null && this.isParameterizedTypeOfExpectedType(iterableType);
    }

    protected boolean isStreamOfExpectedType(Type responseType) {
        Type streamType = TypeReflectionUtils.getExactSuperType(responseType, Stream.class);
        return streamType != null && this.isParameterizedTypeOfExpectedType(streamType);
    }

    protected boolean isParameterizedTypeOfExpectedType(Type responseType) {
        boolean hasOneTypeArgument;
        boolean isParameterizedType = this.isParameterizedType(responseType);
        if (!isParameterizedType) {
            return false;
        }
        Type[] actualTypeArguments = ((ParameterizedType)responseType).getActualTypeArguments();
        boolean bl = hasOneTypeArgument = actualTypeArguments.length == 1;
        if (!hasOneTypeArgument) {
            return false;
        }
        Type actualTypeArgument = actualTypeArguments[0];
        return this.isAssignableFrom(actualTypeArgument) || this.isGenericAssignableFrom(actualTypeArgument) || this.isWildcardTypeWithMatchingUpperBound(actualTypeArgument);
    }

    protected boolean isParameterizedType(Type responseType) {
        return responseType instanceof ParameterizedType;
    }

    protected boolean isWildcardTypeWithMatchingUpperBound(Type responseType) {
        boolean isWildcardType = this.isWildcardType(responseType);
        if (!isWildcardType) {
            return false;
        }
        Type[] upperBounds = ((WildcardType)responseType).getUpperBounds();
        return Arrays.stream(upperBounds).anyMatch(this::isAssignableFrom) || Arrays.stream(upperBounds).anyMatch(this::isGenericAssignableFrom);
    }

    protected boolean isWildcardType(Type responseType) {
        return responseType instanceof WildcardType;
    }

    protected boolean isArrayOfExpectedType(Type responseType) {
        return this.isArray(responseType) && this.isAssignableFrom(((Class)responseType).getComponentType());
    }

    protected boolean isArray(Type responseType) {
        return responseType instanceof Class && ((Class)responseType).isArray();
    }

    protected boolean isGenericArrayOfExpectedType(Type responseType) {
        return this.isGenericArrayType(responseType) && this.isGenericAssignableFrom(((GenericArrayType)responseType).getGenericComponentType());
    }

    protected boolean isGenericArrayType(Type responseType) {
        return responseType instanceof GenericArrayType;
    }

    protected boolean isGenericAssignableFrom(Type responseType) {
        return this.isTypeVariable(responseType) && Arrays.stream(((TypeVariable)responseType).getBounds()).anyMatch(this::isAssignableFrom);
    }

    protected boolean isTypeVariable(Type responseType) {
        return responseType instanceof TypeVariable;
    }

    protected boolean isAssignableFrom(Type responseType) {
        return responseType instanceof Class && this.expectedResponseType.isAssignableFrom((Class)responseType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractResponseType that = (AbstractResponseType)o;
        return Objects.equals(this.expectedResponseType, that.expectedResponseType);
    }

    public int hashCode() {
        return Objects.hash(this.expectedResponseType);
    }
}

