/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.tokenstore.jpa;

import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.tokenstore.ConfigToken;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.UnableToClaimTokenException;
import org.axonframework.eventhandling.tokenstore.UnableToInitializeTokenException;
import org.axonframework.eventhandling.tokenstore.UnableToRetrieveIdentifierException;
import org.axonframework.eventhandling.tokenstore.jpa.TokenEntry;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaTokenStore
implements TokenStore {
    private static final Logger logger = LoggerFactory.getLogger(JpaTokenStore.class);
    private static final String CONFIG_TOKEN_ID = "__config";
    private static final int CONFIG_SEGMENT = 0;
    private final EntityManagerProvider entityManagerProvider;
    private final Serializer serializer;
    private final TemporalAmount claimTimeout;
    private final String nodeId;
    private final LockModeType loadingLockMode;

    public static Builder builder() {
        return new Builder();
    }

    protected JpaTokenStore(Builder builder) {
        builder.validate();
        this.entityManagerProvider = builder.entityManagerProvider;
        this.serializer = builder.serializer;
        this.claimTimeout = builder.claimTimeout;
        this.nodeId = builder.nodeId;
        this.loadingLockMode = builder.loadingLockMode;
    }

    @Override
    public void initializeTokenSegments(String processorName, int segmentCount) throws UnableToClaimTokenException {
        this.initializeTokenSegments(processorName, segmentCount, null);
    }

    @Override
    public void initializeTokenSegments(String processorName, int segmentCount, TrackingToken initialToken) throws UnableToClaimTokenException {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        if (this.fetchSegments(processorName).length > 0) {
            throw new UnableToClaimTokenException("Could not initialize segments. Some segments were already present.");
        }
        for (int segment = 0; segment < segmentCount; ++segment) {
            TokenEntry token = new TokenEntry(processorName, segment, initialToken, this.serializer);
            entityManager.persist((Object)token);
        }
        entityManager.flush();
    }

    @Override
    public void storeToken(TrackingToken token, String processorName, int segment) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        TokenEntry tokenToStore = new TokenEntry(processorName, segment, token, this.serializer);
        byte[] tokenDataToStore = ObjectUtils.getOrDefault(tokenToStore.getSerializedToken(), SerializedObject::getData, null);
        String tokenTypeToStore = ObjectUtils.getOrDefault(tokenToStore.getTokenType(), SerializedType::getName, null);
        int updatedTokens = entityManager.createQuery("UPDATE TokenEntry te SET te.token = :token, te.tokenType = :tokenType, te.timestamp = :timestamp WHERE te.owner = :owner AND te.processorName = :processorName AND te.segment = :segment").setParameter("token", (Object)tokenDataToStore).setParameter("tokenType", (Object)tokenTypeToStore).setParameter("timestamp", (Object)tokenToStore.timestampAsString()).setParameter("owner", (Object)this.nodeId).setParameter("processorName", (Object)processorName).setParameter("segment", (Object)segment).executeUpdate();
        if (updatedTokens == 0) {
            logger.debug("Could not update token [{}] for processor [{}] and segment [{}]. Trying load-then-save approach instead.", new Object[]{token, processorName, segment});
            TokenEntry tokenEntry = this.loadToken(processorName, segment, entityManager);
            tokenEntry.updateToken(token, this.serializer);
        }
    }

    @Override
    public void releaseClaim(String processorName, int segment) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        entityManager.createQuery("UPDATE TokenEntry te SET te.owner = null WHERE te.owner = :owner AND te.processorName = :processorName AND te.segment = :segment").setParameter("processorName", (Object)processorName).setParameter("segment", (Object)segment).setParameter("owner", (Object)this.nodeId).executeUpdate();
    }

    @Override
    public void initializeSegment(TrackingToken token, String processorName, int segment) throws UnableToInitializeTokenException {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        TokenEntry entry = new TokenEntry(processorName, segment, token, this.serializer);
        entityManager.persist((Object)entry);
        entityManager.flush();
    }

    @Override
    public boolean requiresExplicitSegmentInitialization() {
        return true;
    }

    @Override
    public void deleteToken(String processorName, int segment) throws UnableToClaimTokenException {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        int updates = entityManager.createQuery("DELETE FROM TokenEntry te WHERE te.owner = :owner AND te.processorName = :processorName AND te.segment = :segment").setParameter("processorName", (Object)processorName).setParameter("segment", (Object)segment).setParameter("owner", (Object)this.nodeId).executeUpdate();
        if (updates == 0) {
            throw new UnableToClaimTokenException("Unable to remove token. It is not owned by " + this.nodeId);
        }
    }

    @Override
    public TrackingToken fetchToken(String processorName, int segment) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        return this.loadToken(processorName, segment, entityManager).getToken(this.serializer);
    }

    @Override
    public void extendClaim(String processorName, int segment) throws UnableToClaimTokenException {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        int updates = entityManager.createQuery("UPDATE TokenEntry te SET te.timestamp = :timestamp WHERE te.processorName = :processorName AND te.segment = :segment AND te.owner = :owner").setParameter("processorName", (Object)processorName).setParameter("segment", (Object)segment).setParameter("owner", (Object)this.nodeId).setParameter("timestamp", (Object)DateTimeUtils.formatInstant(TokenEntry.clock.instant())).executeUpdate();
        if (updates == 0) {
            throw new UnableToClaimTokenException("Unable to extend the claim on token for processor '" + processorName + "[" + segment + "]'. It is either claimed by another process, or there is no such token.");
        }
    }

    @Override
    public int[] fetchSegments(String processorName) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        List resultList = entityManager.createQuery("SELECT te.segment FROM TokenEntry te WHERE te.processorName = :processorName ORDER BY te.segment ASC", Integer.class).setParameter("processorName", (Object)processorName).getResultList();
        return resultList.stream().mapToInt(i -> i).toArray();
    }

    protected TokenEntry loadToken(String processorName, int segment, EntityManager entityManager) {
        TokenEntry token = (TokenEntry)entityManager.find(TokenEntry.class, (Object)new TokenEntry.PK(processorName, segment), this.loadingLockMode);
        if (token == null) {
            throw new UnableToClaimTokenException(String.format("Unable to claim token '%s[%s]'. It has not been initialized yet", processorName, segment));
        }
        if (!token.claim(this.nodeId, this.claimTimeout)) {
            throw new UnableToClaimTokenException(String.format("Unable to claim token '%s[%s]'. It is owned by '%s'", processorName, segment, token.getOwner()));
        }
        return token;
    }

    @Override
    public Optional<String> retrieveStorageIdentifier() {
        try {
            return Optional.of(this.getConfig()).map(i -> i.get("id"));
        }
        catch (Exception e) {
            throw new UnableToRetrieveIdentifierException("Exception occurred while trying to establish storage identifier", e);
        }
    }

    private ConfigToken getConfig() {
        EntityManager em = this.entityManagerProvider.getEntityManager();
        TokenEntry token = (TokenEntry)em.find(TokenEntry.class, (Object)new TokenEntry.PK(CONFIG_TOKEN_ID, 0), LockModeType.NONE);
        if (token == null) {
            token = new TokenEntry(CONFIG_TOKEN_ID, 0, new ConfigToken(Collections.singletonMap("id", UUID.randomUUID().toString())), this.serializer);
            em.persist((Object)token);
            em.flush();
        }
        return (ConfigToken)token.getToken(this.serializer);
    }

    public Serializer serializer() {
        return this.serializer;
    }

    public static class Builder {
        private LockModeType loadingLockMode = LockModeType.PESSIMISTIC_WRITE;
        private EntityManagerProvider entityManagerProvider;
        private Serializer serializer;
        private TemporalAmount claimTimeout = Duration.ofSeconds(10L);
        private String nodeId = ManagementFactory.getRuntimeMXBean().getName();

        public Builder entityManagerProvider(EntityManagerProvider entityManagerProvider) {
            BuilderUtils.assertNonNull(entityManagerProvider, "EntityManagerProvider may not be null");
            this.entityManagerProvider = entityManagerProvider;
            return this;
        }

        public Builder serializer(Serializer serializer) {
            BuilderUtils.assertNonNull(serializer, "Serializer may not be null");
            this.serializer = serializer;
            return this;
        }

        public Builder claimTimeout(TemporalAmount claimTimeout) {
            BuilderUtils.assertNonNull(claimTimeout, "The claim timeout may not be null");
            this.claimTimeout = claimTimeout;
            return this;
        }

        public Builder nodeId(String nodeId) {
            this.assertNodeId(nodeId, "The nodeId may not be null or empty");
            this.nodeId = nodeId;
            return this;
        }

        public Builder loadingLockMode(LockModeType loadingLockMode) {
            this.loadingLockMode = loadingLockMode;
            return this;
        }

        public JpaTokenStore build() {
            return new JpaTokenStore(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.entityManagerProvider, "The EntityManagerProvider is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.serializer, "The Serializer is a hard requirement and should be provided");
            this.assertNodeId(this.nodeId, "The nodeId is a hard requirement and should be provided");
        }

        private void assertNodeId(String nodeId, String exceptionMessage) {
            BuilderUtils.assertThat(nodeId, name -> Objects.nonNull(name) && !"".equals(name), exceptionMessage);
        }
    }
}

