/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonThreadFactory;
import org.axonframework.common.BuilderUtils;
import org.axonframework.eventhandling.EventTrackerStatusChangeListener;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.messaging.StreamableMessageSource;

public class TrackingEventProcessorConfiguration {
    private static final int DEFAULT_BATCH_SIZE = 1;
    private static final int DEFAULT_THREAD_COUNT = 1;
    private static final int DEFAULT_TOKEN_CLAIM_INTERVAL = 5000;
    private static final long DEFAULT_WORKER_TERMINATION_TIMEOUT_MS = 5000L;
    private final int maxThreadCount;
    private int batchSize = 1;
    private int initialSegmentCount;
    private Function<StreamableMessageSource<TrackedEventMessage<?>>, TrackingToken> initialTrackingTokenBuilder = StreamableMessageSource::createTailToken;
    private Function<String, ThreadFactory> threadFactory;
    private long tokenClaimInterval;
    private int eventAvailabilityTimeout = 1000;
    private EventTrackerStatusChangeListener eventTrackerStatusChangeListener = EventTrackerStatusChangeListener.noOp();
    private boolean autoStart;
    private long workerTerminationTimeout;

    public static TrackingEventProcessorConfiguration forSingleThreadedProcessing() {
        return new TrackingEventProcessorConfiguration(1);
    }

    public static TrackingEventProcessorConfiguration forParallelProcessing(int threadCount) {
        return new TrackingEventProcessorConfiguration(threadCount);
    }

    private TrackingEventProcessorConfiguration(int numberOfSegments) {
        this.initialSegmentCount = numberOfSegments;
        this.maxThreadCount = numberOfSegments;
        this.threadFactory = pn -> new AxonThreadFactory("EventProcessor[" + pn + "]");
        this.tokenClaimInterval = 5000L;
        this.autoStart = true;
        this.workerTerminationTimeout = 5000L;
    }

    public TrackingEventProcessorConfiguration andBatchSize(int batchSize) {
        Assert.isTrue(batchSize > 0, () -> "Batch size must be greater or equal to 1");
        this.batchSize = batchSize;
        return this;
    }

    public TrackingEventProcessorConfiguration andInitialSegmentsCount(int segmentsSize) {
        this.initialSegmentCount = segmentsSize;
        return this;
    }

    public TrackingEventProcessorConfiguration andThreadFactory(Function<String, ThreadFactory> threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public TrackingEventProcessorConfiguration andEventAvailabilityTimeout(long interval, TimeUnit unit) {
        long i = unit.toMillis(interval);
        BuilderUtils.assertThat(i, it -> it <= Integer.MAX_VALUE, "Interval may not be longer than Integer.MAX_VALUE milliseconds long");
        BuilderUtils.assertThat(i, it -> it > 0L, "Interval must be strictly positive");
        this.eventAvailabilityTimeout = (int)i;
        return this;
    }

    public TrackingEventProcessorConfiguration andInitialTrackingToken(Function<StreamableMessageSource<TrackedEventMessage<?>>, TrackingToken> initialTrackingTokenBuilder) {
        this.initialTrackingTokenBuilder = initialTrackingTokenBuilder;
        return this;
    }

    public TrackingEventProcessorConfiguration andTokenClaimInterval(long tokenClaimInterval, TimeUnit timeUnit) {
        this.tokenClaimInterval = timeUnit.toMillis(tokenClaimInterval);
        return this;
    }

    public TrackingEventProcessorConfiguration andEventTrackerStatusChangeListener(EventTrackerStatusChangeListener eventTrackerStatusChangeListener) {
        BuilderUtils.assertNonNull(eventTrackerStatusChangeListener, "EventTrackerStatusChangeListener may not be null");
        this.eventTrackerStatusChangeListener = eventTrackerStatusChangeListener;
        return this;
    }

    @Deprecated
    public TrackingEventProcessorConfiguration andWorkerTerminationTimeout(long workerTerminationTimeoutInMilliseconds) {
        return this.andWorkerTerminationTimeout(workerTerminationTimeoutInMilliseconds, TimeUnit.MILLISECONDS);
    }

    public TrackingEventProcessorConfiguration andWorkerTerminationTimeout(long workerTerminationTimeout, TimeUnit timeUnit) {
        BuilderUtils.assertStrictPositive(workerTerminationTimeout, "The worker termination timeout should be strictly positive");
        this.workerTerminationTimeout = timeUnit.toMillis(workerTerminationTimeout);
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getInitialSegmentsCount() {
        return this.initialSegmentCount;
    }

    public Function<StreamableMessageSource<TrackedEventMessage<?>>, TrackingToken> getInitialTrackingToken() {
        return this.initialTrackingTokenBuilder;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public int getEventAvailabilityTimeout() {
        return this.eventAvailabilityTimeout;
    }

    public ThreadFactory getThreadFactory(String processorName) {
        return this.threadFactory.apply(processorName);
    }

    public long getTokenClaimInterval() {
        return this.tokenClaimInterval;
    }

    public EventTrackerStatusChangeListener getEventTrackerStatusChangeListener() {
        return this.eventTrackerStatusChangeListener;
    }

    public long getWorkerTerminationTimeout() {
        return this.workerTerminationTimeout;
    }
}

