/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.property;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.property.Property;
import org.axonframework.common.property.PropertyAccessException;

public class MethodAccessedProperty<T>
implements Property<T> {
    private final Method method;
    private final String property;

    public MethodAccessedProperty(Method accessorMethod, String propertyName) {
        this.property = propertyName;
        this.method = ReflectionUtils.ensureAccessible(accessorMethod);
    }

    @Override
    public <V> V getValue(T target) {
        try {
            return (V)this.method.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException(String.format("Failed to get value of '%s' using method '%s()' of '%s'. Property methods should be accessible", this.property, this.method.getName(), target.getClass().getName()), e);
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(String.format("Failed to get value of '%s' using method '%s()' of '%s'. Property methods should not throw exceptions.", this.property, this.method.getName(), target.getClass().getName()), e);
        }
    }
}

