/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandMessageHandler;
import org.axonframework.commandhandling.CommandMessageHandlingMember;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.common.Assert;
import org.axonframework.common.Registration;
import org.axonframework.messaging.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

public class AnnotationCommandHandlerAdapter<T>
implements CommandMessageHandler {
    private final T target;
    private final AnnotatedHandlerInspector<T> model;

    public AnnotationCommandHandlerAdapter(T annotatedCommandHandler) {
        this(annotatedCommandHandler, ClasspathParameterResolverFactory.forClass(annotatedCommandHandler.getClass()));
    }

    public AnnotationCommandHandlerAdapter(T annotatedCommandHandler, ParameterResolverFactory parameterResolverFactory) {
        this(annotatedCommandHandler, parameterResolverFactory, ClasspathHandlerDefinition.forClass(annotatedCommandHandler.getClass()));
    }

    public AnnotationCommandHandlerAdapter(T annotatedCommandHandler, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        Assert.notNull(annotatedCommandHandler, () -> "annotatedCommandHandler may not be null");
        this.model = AnnotatedHandlerInspector.inspectType(annotatedCommandHandler.getClass(), parameterResolverFactory, handlerDefinition);
        this.target = annotatedCommandHandler;
    }

    public Registration subscribe(CommandBus commandBus) {
        Collection subscriptions = this.supportedCommandNames().stream().map(supportedCommand -> commandBus.subscribe((String)supportedCommand, this)).collect(Collectors.toCollection(ArrayDeque::new));
        return () -> subscriptions.stream().map(Registration::cancel).reduce(Boolean::logicalOr).orElse(false);
    }

    @Override
    public Object handle(CommandMessage<?> command) throws Exception {
        return this.model.getHandlers().stream().filter(h -> h.canHandle(command)).findFirst().orElseThrow(() -> new NoHandlerForCommandException(String.format("No handler available to handle command [%s]", command.getCommandName()))).handle(command, this.target);
    }

    @Override
    public boolean canHandle(CommandMessage<?> message) {
        return this.model.getHandlers().stream().anyMatch(h -> h.canHandle(message));
    }

    @Override
    public Set<String> supportedCommandNames() {
        return this.model.getHandlers().stream().map(h -> h.unwrap(CommandMessageHandlingMember.class).orElse(null)).filter(Objects::nonNull).map(CommandMessageHandlingMember::commandName).collect(Collectors.toSet());
    }
}

