/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.AxonThreadFactory;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.deadline.AbstractDeadlineManager;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.ExecutionException;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.messaging.ScopeAwareProvider;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDeadlineManager
extends AbstractDeadlineManager {
    private static final Logger logger = LoggerFactory.getLogger(SimpleDeadlineManager.class);
    private static final String THREAD_FACTORY_GROUP_NAME = "deadlineManager";
    private final ScopeAwareProvider scopeAwareProvider;
    private final ScheduledExecutorService scheduledExecutorService;
    private final TransactionManager transactionManager;
    private final Map<DeadlineId, Future<?>> scheduledTasks = new ConcurrentHashMap();

    public static Builder builder() {
        return new Builder();
    }

    protected SimpleDeadlineManager(Builder builder) {
        builder.validate();
        this.scopeAwareProvider = builder.scopeAwareProvider;
        this.scheduledExecutorService = builder.scheduledExecutorService;
        this.transactionManager = builder.transactionManager;
    }

    @Override
    public String schedule(Instant triggerDateTime, String deadlineName, Object messageOrPayload, ScopeDescriptor deadlineScope) {
        DeadlineMessage deadlineMessage = GenericDeadlineMessage.asDeadlineMessage(deadlineName, messageOrPayload, triggerDateTime);
        String deadlineId = deadlineMessage.getIdentifier();
        this.runOnPrepareCommitOrNow(() -> {
            DeadlineMessage interceptedDeadlineMessage = this.processDispatchInterceptors(deadlineMessage);
            DeadlineTask deadlineTask = new DeadlineTask(deadlineName, deadlineScope, interceptedDeadlineMessage, deadlineId);
            Duration triggerDuration = Duration.between(Instant.now(), triggerDateTime);
            ScheduledFuture<?> scheduledFuture = this.scheduledExecutorService.schedule(deadlineTask, triggerDuration.toMillis(), TimeUnit.MILLISECONDS);
            this.scheduledTasks.put(new DeadlineId(deadlineName, deadlineId), scheduledFuture);
        });
        return deadlineId;
    }

    @Override
    public void cancelSchedule(String deadlineName, String scheduleId) {
        this.runOnPrepareCommitOrNow(() -> this.cancelSchedule(new DeadlineId(deadlineName, scheduleId)));
    }

    @Override
    public void cancelAll(String deadlineName) {
        this.runOnPrepareCommitOrNow(() -> this.scheduledTasks.entrySet().stream().map(Map.Entry::getKey).filter(scheduledTaskId -> scheduledTaskId.getDeadlineName().equals(deadlineName)).forEach(this::cancelSchedule));
    }

    private void cancelSchedule(DeadlineId deadlineId) {
        Future<?> future = this.scheduledTasks.remove(deadlineId);
        if (future != null) {
            future.cancel(false);
        }
    }

    private class DeadlineTask
    implements Runnable {
        private final String deadlineName;
        private final ScopeDescriptor deadlineScope;
        private final DeadlineMessage<?> deadlineMessage;
        private final String deadlineId;

        private DeadlineTask(String deadlineName, ScopeDescriptor deadlineScope, DeadlineMessage<?> deadlineMessage, String deadlineId) {
            this.deadlineName = deadlineName;
            this.deadlineScope = deadlineScope;
            this.deadlineMessage = deadlineMessage;
            this.deadlineId = deadlineId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug("Triggered deadline");
            }
            try {
                Instant triggerInstant = GenericEventMessage.clock.instant();
                DefaultUnitOfWork unitOfWork = new DefaultUnitOfWork(new GenericDeadlineMessage(this.deadlineName, this.deadlineMessage, () -> triggerInstant));
                unitOfWork.attachTransaction(SimpleDeadlineManager.this.transactionManager);
                DefaultInterceptorChain<DeadlineMessage> chain = new DefaultInterceptorChain<DeadlineMessage>(unitOfWork, SimpleDeadlineManager.this.handlerInterceptors(), deadlineMessage -> {
                    this.executeScheduledDeadline((DeadlineMessage)deadlineMessage, this.deadlineScope);
                    return null;
                });
                ResultMessage<Object> resultMessage = unitOfWork.executeWithResult(chain::proceed);
                if (resultMessage.isExceptional()) {
                    Throwable e = resultMessage.exceptionResult();
                    logger.error("An error occurred while triggering the deadline [{}] with identifier [{}]", new Object[]{this.deadlineName, this.deadlineId, e});
                }
            }
            catch (Exception e) {
                logger.error("An error occurred while triggering the deadline [{}] with identifier [{}]", new Object[]{this.deadlineName, this.deadlineId, e});
            }
            finally {
                SimpleDeadlineManager.this.scheduledTasks.remove(new DeadlineId(this.deadlineName, this.deadlineId));
            }
        }

        private void executeScheduledDeadline(DeadlineMessage deadlineMessage, ScopeDescriptor deadlineScope) {
            SimpleDeadlineManager.this.scopeAwareProvider.provideScopeAwareStream(deadlineScope).filter(scopeAwareComponent -> scopeAwareComponent.canResolve(deadlineScope)).forEach(scopeAwareComponent -> {
                try {
                    scopeAwareComponent.send(deadlineMessage, deadlineScope);
                }
                catch (Exception e) {
                    String exceptionMessage = String.format("Failed to send a DeadlineMessage for scope [%s]", deadlineScope.scopeDescription());
                    throw new ExecutionException(exceptionMessage, e);
                }
            });
        }
    }

    public static class Builder {
        private ScopeAwareProvider scopeAwareProvider;
        private ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new AxonThreadFactory("deadlineManager"));
        private TransactionManager transactionManager = NoTransactionManager.INSTANCE;

        public Builder scopeAwareProvider(ScopeAwareProvider scopeAwareProvider) {
            BuilderUtils.assertNonNull(scopeAwareProvider, "ScopeAwareProvider may not be null");
            this.scopeAwareProvider = scopeAwareProvider;
            return this;
        }

        public Builder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            BuilderUtils.assertNonNull(scheduledExecutorService, "ScheduledExecutorService may not be null");
            this.scheduledExecutorService = scheduledExecutorService;
            return this;
        }

        public Builder transactionManager(TransactionManager transactionManager) {
            BuilderUtils.assertNonNull(transactionManager, "TransactionManager may not be null");
            this.transactionManager = transactionManager;
            return this;
        }

        public SimpleDeadlineManager build() {
            return new SimpleDeadlineManager(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.scopeAwareProvider, "The ScopeAwareProvider is a hard requirement and should be provided");
        }
    }

    private static class DeadlineId {
        private final String deadlineName;
        private final String deadlineId;

        private DeadlineId(String deadlineName, String deadlineId) {
            this.deadlineId = deadlineId;
            this.deadlineName = deadlineName;
        }

        public String getDeadlineName() {
            return this.deadlineName;
        }

        public String getDeadlineId() {
            return this.deadlineId;
        }

        public int hashCode() {
            return Objects.hash(this.deadlineName, this.deadlineId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DeadlineId other = (DeadlineId)obj;
            return Objects.equals(this.deadlineName, other.deadlineName) && Objects.equals(this.deadlineId, other.deadlineId);
        }

        public String toString() {
            return "DeadlineId{deadlineName='" + this.deadlineName + '\'' + ", deadlineId='" + this.deadlineId + '\'' + '}';
        }
    }
}

