/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public abstract class ProcessUtils {
    private ProcessUtils() {
    }

    public static void executeWithRetry(Runnable runnable, Predicate<RuntimeException> retryPredicate, long timeout, TimeUnit timeUnit, long retryInterval) {
        long completeBefore = System.currentTimeMillis() + timeUnit.toMillis(timeout);
        RuntimeException lastException = new RuntimeException();
        while (completeBefore > System.currentTimeMillis()) {
            try {
                runnable.run();
                return;
            }
            catch (RuntimeException re) {
                if (!retryPredicate.test(re)) {
                    throw re;
                }
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw re;
                }
                lastException = re;
            }
        }
        throw lastException;
    }
}

