/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates.detection;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MachineId {
    private static final Logger logger = LoggerFactory.getLogger(MachineId.class);
    private static final String MACHINE_ID_PATH = "/.axoniq/.machine-id";
    private String machineId;

    public MachineId() {
        this.initialize();
    }

    public String get() {
        return this.machineId;
    }

    private void initialize() {
        try {
            File file = this.getFile();
            if (file == null) {
                logger.debug("Could not determine user home directory. Machine ID will not be stored.");
                this.machineId = UUID.randomUUID().toString();
                return;
            }
            if (file.exists()) {
                this.machineId = new String(Files.readAllBytes(file.toPath()));
                return;
            }
            File parentDir = this.getFile().getParentFile();
            if (!parentDir.exists() && !parentDir.mkdirs()) {
                throw new IOException("Failed to create parent directory: " + parentDir.getAbsolutePath());
            }
            this.machineId = UUID.randomUUID().toString();
            Files.write(file.toPath(), this.machineId.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            logger.debug("Failed to initialize machine id", (Throwable)e);
        }
    }

    private File getFile() {
        String pwdDir = System.getProperty("user.home");
        if (pwdDir == null) {
            return null;
        }
        String installationIdFilePath = pwdDir + MACHINE_ID_PATH;
        return new File(installationIdFilePath);
    }
}

