/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.axonframework.common.BuilderUtils;
import org.axonframework.lifecycle.Lifecycle;
import org.axonframework.updates.UpdateCheckerHttpClient;
import org.axonframework.updates.UpdateCheckerReporter;
import org.axonframework.updates.api.UpdateCheckRequest;
import org.axonframework.updates.api.UpdateCheckResponse;
import org.axonframework.updates.configuration.UsagePropertyProvider;
import org.axonframework.updates.detection.AxonVersionDetector;
import org.axonframework.updates.detection.KotlinVersion;
import org.axonframework.updates.detection.MachineId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateChecker
implements Runnable,
Lifecycle {
    private static final Logger logger = LoggerFactory.getLogger(UpdateChecker.class);
    private final UpdateCheckerHttpClient client;
    private final MachineId machineId;
    private final UpdateCheckerReporter reporter;
    private final ScheduledExecutorService executor;
    private boolean firstRequest = true;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private int errorRetryBackoffFactor = 1;

    public UpdateChecker(UpdateCheckerHttpClient client, UpdateCheckerReporter reporter) {
        this(client, reporter, Executors.newScheduledThreadPool(1));
    }

    public UpdateChecker(UpdateCheckerHttpClient client, UpdateCheckerReporter reporter, ScheduledExecutorService executor) {
        BuilderUtils.assertNonNull(client, "The client must not be null.");
        BuilderUtils.assertNonNull(reporter, "The reporter must not be null.");
        BuilderUtils.assertNonNull(executor, "The executor must not be null.");
        this.client = client;
        this.machineId = new MachineId();
        this.reporter = reporter;
        this.executor = executor;
    }

    @Override
    public void registerLifecycleHandlers(@Nonnull Lifecycle.LifecycleRegistry lifecycle) {
        lifecycle.onStart(-134217728, this::start);
        lifecycle.onShutdown(-134217728, this::stop);
    }

    public void start() {
        try {
            if (!this.started.compareAndSet(false, true)) {
                logger.debug("The AxonIQ UpdateChecker was already started.");
                return;
            }
            UsagePropertyProvider userProperties = UsagePropertyProvider.create(new UsagePropertyProvider[0]);
            if (userProperties.getDisabled().booleanValue()) {
                logger.info("You have opted out of the AxonIQ UpdateChecker. No updates or vulnerabilities will be checked. See https://www.axoniq.io/update-check for more information.");
                return;
            }
            logger.info("Your AxonIQ libraries will be checked for updates periodically. See https://www.axoniq.io/update-check for more information.");
            this.executor.schedule(this, 1000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.warn("Failed to start the UpdateChecker task.", (Throwable)e);
        }
    }

    @Override
    public void run() {
        if (!this.started.get()) {
            return;
        }
        try {
            UpdateCheckRequest requestBody = this.buildRequest();
            Optional<UpdateCheckResponse> response = this.client.sendRequest(requestBody, this.firstRequest);
            if (!response.isPresent()) {
                this.scheduleErrorRetry();
                return;
            }
            UpdateCheckResponse updateCheckResponse = response.get();
            this.reporter.report(requestBody, updateCheckResponse);
            logger.debug("AxonIQ will check library updates and vulnerabilities again in {} seconds.", (Object)updateCheckResponse);
            this.executor.schedule(this, (long)updateCheckResponse.checkInterval() * 1000L, TimeUnit.MILLISECONDS);
            this.errorRetryBackoffFactor = 1;
            this.firstRequest = false;
        }
        catch (Exception e) {
            logger.warn("The AxonIQ UpdateChecker failed to fetch updates and vulnerabilities.", (Throwable)e);
            this.scheduleErrorRetry();
        }
    }

    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            logger.info("Stopped the AxonIQ UpdateChecker. No further updates will be checked.");
            this.executor.shutdown();
        }
    }

    private void scheduleErrorRetry() {
        ++this.errorRetryBackoffFactor;
        int nextInvocationTime = Math.min((int)(Math.pow(2.0, this.errorRetryBackoffFactor) * 1000.0), 60000);
        this.executor.schedule(this, (long)nextInvocationTime, TimeUnit.MILLISECONDS);
    }

    private UpdateCheckRequest buildRequest() {
        String jvmVendor = System.getProperty("java.vendor");
        String javaVersion = System.getProperty("java.version");
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        String osVersion = System.getProperty("os.version");
        String installationId = UUID.randomUUID().toString();
        return new UpdateCheckRequest(this.machineId.get(), installationId, osName, osVersion, osArch, javaVersion, jvmVendor, KotlinVersion.get(), AxonVersionDetector.safeDetectAxonModules());
    }

    public boolean isStarted() {
        return this.started.get();
    }
}

