/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.util.Iterator;
import javax.annotation.Nonnull;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.InterceptorChainParameterResolverFactory;
import org.axonframework.messaging.annotation.MessageHandlerInterceptorMemberChain;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.NoMoreInterceptors;

public class ChainedMessageHandlerInterceptorMember<T>
implements MessageHandlerInterceptorMemberChain<T> {
    private final MessageHandlingMember<? super T> delegate;
    private final MessageHandlerInterceptorMemberChain<T> next;

    public ChainedMessageHandlerInterceptorMember(Class<?> handlerType, Iterator<MessageHandlingMember<? super T>> iterator) {
        this.delegate = iterator.next();
        this.next = iterator.hasNext() ? new ChainedMessageHandlerInterceptorMember<T>(handlerType, iterator) : NoMoreInterceptors.instance();
    }

    @Override
    public Object handle(@Nonnull Message<?> message, @Nonnull T target, @Nonnull MessageHandlingMember<? super T> handler) throws Exception {
        return InterceptorChainParameterResolverFactory.callWithInterceptorChain(() -> this.next.handle(message, target, handler), () -> this.doHandle(message, target, handler));
    }

    private Object doHandle(Message<?> message, T target, MessageHandlingMember<? super T> handler) throws Exception {
        return this.delegate.canHandle(message) ? this.delegate.handle(message, target) : this.next.handle(message, (T)target, handler);
    }
}

