/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.function.Supplier;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.GenericTrackedDomainEventMessage;
import org.axonframework.eventhandling.GenericTrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.deadletter.jdbc.DeadLetterJdbcConverter;
import org.axonframework.eventhandling.deadletter.jdbc.DeadLetterSchema;
import org.axonframework.eventhandling.deadletter.jdbc.JdbcDeadLetter;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.deadletter.ThrowableCause;
import org.axonframework.serialization.SerializedMessage;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;

public class DefaultDeadLetterJdbcConverter<E extends EventMessage<?>>
implements DeadLetterJdbcConverter<E, JdbcDeadLetter<E>> {
    private final DeadLetterSchema schema;
    private final Serializer genericSerializer;
    private final Serializer eventSerializer;

    protected DefaultDeadLetterJdbcConverter(Builder<E> builder) {
        builder.validate();
        this.schema = ((Builder)builder).schema;
        this.genericSerializer = ((Builder)builder).genericSerializer;
        this.eventSerializer = ((Builder)builder).eventSerializer;
    }

    public static <E extends EventMessage<?>> Builder<E> builder() {
        return new Builder();
    }

    @Override
    public JdbcDeadLetter<E> convertToLetter(ResultSet resultSet) throws SQLException {
        GenericEventMessage eventMessage;
        SerializedMessage<?> serializedMessage = this.convertToSerializedMessage(resultSet);
        String eventTimestampString = resultSet.getString(this.schema.timestampColumn());
        Supplier<Instant> timestampSupplier = () -> DateTimeUtils.parseInstant(eventTimestampString);
        if (resultSet.getString(this.schema.tokenTypeColumn()) != null) {
            TrackingToken trackingToken = this.convertToTrackingToken(resultSet);
            eventMessage = resultSet.getString(this.schema.aggregateIdentifierColumn()) != null ? new GenericTrackedDomainEventMessage(trackingToken, resultSet.getString(this.schema.aggregateTypeColumn()), resultSet.getString(this.schema.aggregateIdentifierColumn()), resultSet.getLong(this.schema.sequenceNumberColumn()), serializedMessage, timestampSupplier) : new GenericTrackedEventMessage(trackingToken, serializedMessage, timestampSupplier);
        } else {
            eventMessage = resultSet.getString(this.schema.aggregateIdentifierColumn()) != null ? new GenericDomainEventMessage(resultSet.getString(this.schema.aggregateTypeColumn()), resultSet.getString(this.schema.aggregateIdentifierColumn()), resultSet.getLong(this.schema.sequenceNumberColumn()), serializedMessage.getPayload(), serializedMessage.getMetaData(), serializedMessage.getIdentifier(), timestampSupplier.get()) : new GenericEventMessage(serializedMessage, timestampSupplier);
        }
        String deadLetterIdentifier = resultSet.getString(this.schema.deadLetterIdentifierColumn());
        long sequenceIndex = resultSet.getLong(this.schema.sequenceIndexColumn());
        String sequenceIdentifier = resultSet.getString(this.schema.sequenceIdentifierColumn());
        Instant enqueuedAt = DateTimeUtils.parseInstant(resultSet.getString(this.schema.enqueuedAtColumn()));
        Instant lastTouched = DateTimeUtils.parseInstant(resultSet.getString(this.schema.lastTouchedColumn()));
        ThrowableCause cause = null;
        String causeType = resultSet.getString(this.schema.causeTypeColumn());
        if (causeType != null) {
            cause = new ThrowableCause(causeType, resultSet.getString(this.schema.causeMessageColumn()));
        }
        MetaData diagnostics = this.convertToDiagnostics(resultSet);
        return new JdbcDeadLetter(deadLetterIdentifier, sequenceIndex, sequenceIdentifier, enqueuedAt, lastTouched, cause, diagnostics, eventMessage);
    }

    private SerializedMessage<?> convertToSerializedMessage(ResultSet resultSet) throws SQLException {
        SerializedObject<byte[]> serializedPayload = this.convertToSerializedPayload(resultSet);
        SerializedObject<byte[]> serializedMetaData = this.convertToSerializedMetaData(resultSet);
        return new SerializedMessage(resultSet.getString(this.schema.eventIdentifierColumn()), serializedPayload, serializedMetaData, this.eventSerializer);
    }

    private SerializedObject<byte[]> convertToSerializedPayload(ResultSet resultSet) throws SQLException {
        return new SimpleSerializedObject<byte[]>(resultSet.getBytes(this.schema.payloadColumn()), byte[].class, resultSet.getString(this.schema.payloadTypeColumn()), resultSet.getString(this.schema.payloadRevisionColumn()));
    }

    private SerializedObject<byte[]> convertToSerializedMetaData(ResultSet resultSet) throws SQLException {
        return new SimpleSerializedObject<byte[]>(resultSet.getBytes(this.schema.metaDataColumn()), byte[].class, MetaData.class.getName(), null);
    }

    private TrackingToken convertToTrackingToken(ResultSet resultSet) throws SQLException {
        SimpleSerializedObject<byte[]> serializedToken = new SimpleSerializedObject<byte[]>(resultSet.getBytes(this.schema.tokenColumn()), byte[].class, resultSet.getString(this.schema.tokenTypeColumn()), null);
        return (TrackingToken)this.genericSerializer.deserialize(serializedToken);
    }

    private MetaData convertToDiagnostics(ResultSet resultSet) throws SQLException {
        SimpleSerializedObject<byte[]> serializedDiagnostics = new SimpleSerializedObject<byte[]>(resultSet.getBytes(this.schema.diagnosticsColumn()), byte[].class, MetaData.class.getName(), null);
        return (MetaData)this.eventSerializer.deserialize(serializedDiagnostics);
    }

    protected static class Builder<E extends EventMessage<?>> {
        private DeadLetterSchema schema = DeadLetterSchema.defaultSchema();
        private Serializer genericSerializer;
        private Serializer eventSerializer;

        protected Builder() {
        }

        public Builder<E> schema(DeadLetterSchema schema) {
            BuilderUtils.assertNonNull(schema, "DeadLetterSchema may not be null");
            this.schema = schema;
            return this;
        }

        public Builder<E> genericSerializer(Serializer genericSerializer) {
            BuilderUtils.assertNonNull(genericSerializer, "The generic Serializer may not be null");
            this.genericSerializer = genericSerializer;
            return this;
        }

        public Builder<E> eventSerializer(Serializer eventSerializer) {
            BuilderUtils.assertNonNull(eventSerializer, "The event Serializer may not be null");
            this.eventSerializer = eventSerializer;
            return this;
        }

        public DefaultDeadLetterJdbcConverter<E> build() {
            return new DefaultDeadLetterJdbcConverter(this);
        }

        protected void validate() {
            BuilderUtils.assertNonNull(this.genericSerializer, "The generic Serializer is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.eventSerializer, "The event Serializer is a hard requirement and should be provided");
        }
    }
}

