/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing;

import java.util.Objects;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.messaging.Message;
import org.axonframework.queryhandling.QueryMessage;

public class SpanUtils {
    private SpanUtils() {
    }

    public static String determineMessageName(Message<?> message) {
        String queryName;
        String commandName;
        String messageName = message.getPayloadType().getSimpleName();
        if (message instanceof CommandMessage && !Objects.equals(commandName = ((CommandMessage)message).getCommandName(), message.getPayloadType().getName())) {
            messageName = commandName;
        }
        if (message instanceof QueryMessage && !Objects.equals(queryName = ((QueryMessage)message).getQueryName(), message.getPayloadType().getName())) {
            messageName = queryName;
        }
        if (message instanceof DeadlineMessage) {
            if (message.getPayload() != null) {
                return ((DeadlineMessage)message).getDeadlineName() + "," + message.getPayloadType().getSimpleName();
            }
            return ((DeadlineMessage)message).getDeadlineName();
        }
        return messageName;
    }
}

