/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.caching;

import java.util.EnumSet;
import java.util.function.UnaryOperator;
import org.axonframework.common.Registration;
import org.axonframework.common.caching.AbstractCacheAdapter;
import org.axonframework.common.caching.Cache;
import org.ehcache.core.Ehcache;
import org.ehcache.event.CacheEvent;
import org.ehcache.event.CacheEventListener;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.ehcache.event.EventType;

public class EhCache3Adapter
extends AbstractCacheAdapter<CacheEventListener> {
    private final Ehcache ehCache;

    public EhCache3Adapter(Ehcache ehCache) {
        this.ehCache = ehCache;
    }

    @Override
    public <K, V> V get(K key) {
        Object value = this.ehCache.get(key);
        return (V)(value != null ? value : null);
    }

    @Override
    public void put(Object key, Object value) {
        this.ehCache.put(key, value);
    }

    @Override
    public boolean putIfAbsent(Object key, Object value) {
        return this.ehCache.putIfAbsent(key, value) == null;
    }

    @Override
    public boolean remove(Object key) {
        Object value = this.ehCache.get(key);
        if (value == null) {
            return false;
        }
        return this.ehCache.remove(key, value);
    }

    @Override
    public void removeAll() {
        this.ehCache.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.ehCache.containsKey(key);
    }

    @Override
    public <V> void computeIfPresent(Object key, UnaryOperator<V> update) {
        Object newValue;
        Object oldValue;
        while ((oldValue = this.ehCache.get(key)) != null && !this.replaceOrRemove(key, oldValue, newValue = update.apply(oldValue))) {
        }
    }

    private <V> boolean replaceOrRemove(Object key, V oldValue, V newValue) {
        return newValue != null ? this.ehCache.replace(key, oldValue, newValue) : this.remove(key);
    }

    @Override
    protected CacheEventListener createListenerAdapter(Cache.EntryListener cacheEntryListener) {
        return new CacheEventListenerAdapter(cacheEntryListener);
    }

    @Override
    protected Registration doRegisterListener(CacheEventListener listenerAdapter) {
        this.ehCache.getRuntimeConfiguration().registerCacheEventListener(listenerAdapter, EventOrdering.ORDERED, EventFiring.SYNCHRONOUS, EnumSet.allOf(EventType.class));
        return () -> {
            try {
                this.ehCache.getRuntimeConfiguration().deregisterCacheEventListener(listenerAdapter);
            }
            catch (IllegalStateException e) {
                return false;
            }
            return true;
        };
    }

    private static class CacheEventListenerAdapter
    implements CacheEventListener {
        private final Cache.EntryListener delegate;

        public CacheEventListenerAdapter(Cache.EntryListener delegate) {
            this.delegate = delegate;
        }

        public void onEvent(CacheEvent event) {
            switch (event.getType()) {
                case CREATED: {
                    this.delegate.onEntryCreated(event.getKey(), event.getNewValue());
                    break;
                }
                case UPDATED: {
                    this.delegate.onEntryUpdated(event.getKey(), event.getNewValue());
                    break;
                }
                case REMOVED: 
                case EVICTED: {
                    this.delegate.onEntryRemoved(event.getKey());
                    break;
                }
                case EXPIRED: {
                    this.delegate.onEntryExpired(event.getKey());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unsupported event type " + event.getType()));
                }
            }
        }
    }
}

