/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonThreadFactory;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.messaging.StreamableMessageSource;

public class TrackingEventProcessorConfiguration {
    private static final int DEFAULT_BATCH_SIZE = 1;
    private static final int DEFAULT_THREAD_COUNT = 1;
    private static final int DEFAULT_TOKEN_CLAIM_INTERVAL = 5000;
    private final int maxThreadCount;
    private int batchSize = 1;
    private int initialSegmentCount;
    private Function<StreamableMessageSource, TrackingToken> initialTrackingTokenBuilder = StreamableMessageSource::createTailToken;
    private Function<String, ThreadFactory> threadFactory;
    private long tokenClaimInterval;

    private TrackingEventProcessorConfiguration(int numberOfSegments) {
        this.initialSegmentCount = numberOfSegments;
        this.maxThreadCount = numberOfSegments;
        this.threadFactory = pn -> new AxonThreadFactory("EventProcessor[" + pn + "]");
        this.tokenClaimInterval = 5000L;
    }

    public static TrackingEventProcessorConfiguration forSingleThreadedProcessing() {
        return new TrackingEventProcessorConfiguration(1);
    }

    public static TrackingEventProcessorConfiguration forParallelProcessing(int threadCount) {
        return new TrackingEventProcessorConfiguration(threadCount);
    }

    public TrackingEventProcessorConfiguration andBatchSize(int batchSize) {
        Assert.isTrue(batchSize > 0, () -> "Batch size must be greater or equal to 1");
        this.batchSize = batchSize;
        return this;
    }

    public TrackingEventProcessorConfiguration andInitialSegmentsCount(int segmentsSize) {
        this.initialSegmentCount = segmentsSize;
        return this;
    }

    public TrackingEventProcessorConfiguration andThreadFactory(Function<String, ThreadFactory> threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public TrackingEventProcessorConfiguration andInitialTrackingToken(Function<StreamableMessageSource, TrackingToken> initialTrackingTokenBuilder) {
        this.initialTrackingTokenBuilder = initialTrackingTokenBuilder;
        return this;
    }

    public TrackingEventProcessorConfiguration andTokenClaimInterval(long tokenClaimInterval, TimeUnit timeUnit) {
        this.tokenClaimInterval = timeUnit.toMillis(tokenClaimInterval);
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getInitialSegmentsCount() {
        return this.initialSegmentCount;
    }

    public Function<StreamableMessageSource, TrackingToken> getInitialTrackingToken() {
        return this.initialTrackingTokenBuilder;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public ThreadFactory getThreadFactory(String processorName) {
        return this.threadFactory.apply(processorName);
    }

    public long getTokenClaimInterval() {
        return this.tokenClaimInterval;
    }
}

