/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.function.Function;
import java.util.stream.Stream;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventData;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GenericTrackedDomainEventMessage;
import org.axonframework.eventhandling.GenericTrackedEventMessage;
import org.axonframework.eventhandling.TrackedEventData;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.serialization.LazyDeserializingObject;
import org.axonframework.serialization.SerializedMessage;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.serialization.upcasting.event.InitialEventRepresentation;
import org.axonframework.serialization.upcasting.event.IntermediateEventRepresentation;

public abstract class EventUtils {
    private EventUtils() {
    }

    public static <T> TrackedEventMessage<T> asTrackedEventMessage(EventMessage<T> eventMessage, TrackingToken trackingToken) {
        if (eventMessage instanceof DomainEventMessage) {
            return new GenericTrackedDomainEventMessage(trackingToken, (DomainEventMessage)eventMessage);
        }
        return new GenericTrackedEventMessage<T>(trackingToken, eventMessage);
    }

    public static <T> DomainEventMessage<T> asDomainEventMessage(EventMessage<T> eventMessage) {
        if (eventMessage instanceof DomainEventMessage) {
            return (DomainEventMessage)eventMessage;
        }
        return new GenericDomainEventMessage<T>(null, eventMessage.getIdentifier(), 0L, eventMessage, eventMessage::getTimestamp);
    }

    public static Stream<TrackedEventMessage<?>> upcastAndDeserializeTrackedEvents(Stream<? extends TrackedEventData<?>> eventEntryStream, Serializer serializer, EventUpcaster upcasterChain) {
        Stream<IntermediateEventRepresentation> upcastResult = EventUtils.upcastAndDeserialize(eventEntryStream, upcasterChain, entry -> new InitialEventRepresentation((EventData<?>)entry, serializer));
        return upcastResult.map(ir -> {
            SerializedMessage serializedMessage = new SerializedMessage(ir.getMessageIdentifier(), new LazyDeserializingObject(ir::getData, ir.getType(), serializer), ir.getMetaData());
            if (ir.getAggregateIdentifier().isPresent()) {
                return new GenericTrackedDomainEventMessage(ir.getTrackingToken().get(), (String)ir.getAggregateType().orElse(null), ir.getAggregateIdentifier().get(), (long)ir.getSequenceNumber().get(), serializedMessage, ir::getTimestamp);
            }
            return new GenericTrackedEventMessage(ir.getTrackingToken().get(), serializedMessage, ir::getTimestamp);
        });
    }

    private static Stream<IntermediateEventRepresentation> upcastAndDeserialize(Stream<? extends EventData<?>> eventEntryStream, EventUpcaster upcasterChain, Function<EventData<?>, IntermediateEventRepresentation> entryConverter) {
        return upcasterChain.upcast(eventEntryStream.map(entryConverter));
    }
}

