/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandMessageHandlingMember;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.WrappedMessageHandlingMember;

public class MethodCommandHandlerDefinition
implements HandlerEnhancerDefinition {
    @Override
    public <T> MessageHandlingMember<T> wrapHandler(MessageHandlingMember<T> original) {
        return original.annotationAttributes(CommandHandler.class).map(attr -> new MethodCommandMessageHandlingMember(original, (Map)attr)).orElse(original);
    }

    private static class MethodCommandMessageHandlingMember<T>
    extends WrappedMessageHandlingMember<T>
    implements CommandMessageHandlingMember<T> {
        private final String commandName;
        private final boolean isFactoryHandler;
        private final String routingKey;

        private MethodCommandMessageHandlingMember(MessageHandlingMember<T> delegate, Map<String, Object> annotationAttributes) {
            super(delegate);
            boolean factoryMethod;
            this.routingKey = "".equals(annotationAttributes.get("routingKey")) ? null : (String)annotationAttributes.get("routingKey");
            Executable executable = delegate.unwrap(Executable.class).orElseThrow(() -> new AxonConfigurationException("The @CommandHandler annotation must be put on an Executable (either directly or as Meta Annotation)"));
            this.commandName = "".equals(annotationAttributes.get("commandName")) ? delegate.payloadType().getName() : (String)annotationAttributes.get("commandName");
            boolean bl = factoryMethod = executable instanceof Method && Modifier.isStatic(executable.getModifiers());
            if (factoryMethod && !executable.getDeclaringClass().isAssignableFrom(((Method)executable).getReturnType())) {
                throw new AxonConfigurationException("static @CommandHandler methods must declare a return value which is equal to or a subclass of the declaring time");
            }
            this.isFactoryHandler = executable instanceof Constructor || factoryMethod;
        }

        @Override
        public boolean canHandle(Message<?> message) {
            return super.canHandle(message) && this.commandName.equals(((CommandMessage)message).getCommandName());
        }

        @Override
        public String routingKey() {
            return this.routingKey;
        }

        @Override
        public String commandName() {
            return this.commandName;
        }

        @Override
        public boolean isFactoryHandler() {
            return this.isFactoryHandler;
        }
    }
}

